/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import su.uTa4u.tfcwoodwork.ModTags;
import su.uTa4u.tfcwoodwork.TFCWoodworking;
import su.uTa4u.tfcwoodwork.entities.AbstractWoodProjectile;

@OnlyIn(value=Dist.CLIENT)
public class WoodProjectilefRenderer
extends EntityRenderer<AbstractWoodProjectile> {
    private final BlockRenderDispatcher dispatcher;

    public WoodProjectilefRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.25f;
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(AbstractWoodProjectile entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        BlockState blockstate = entity.getBlockState();
        if (blockstate.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0, -0.3125, 0.0);
        poseStack.translate(0.0, 0.5, 0.0);
        boolean isMirrored = entity.getMirrored();
        Direction dir = entity.getDirection();
        Direction.Axis axis = dir.getAxis();
        float angle = Mth.rotLerp((float)partialTicks, (float)entity.getHRot0(), (float)entity.getHRot());
        if (blockstate.is(ModTags.Blocks.LOGS_QUARTER)) {
            if (axis == Direction.Axis.X) {
                poseStack.mulPose(WoodProjectilefRenderer.mojandAxisFromDir(dir, isMirrored).rotationDegrees(angle));
                if (isMirrored) {
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                }
            }
            if (axis == Direction.Axis.Z) {
                poseStack.mulPose(WoodProjectilefRenderer.mojandAxisFromDir(dir, !isMirrored).rotationDegrees(angle));
                if (isMirrored) {
                    poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                }
            }
            if (dir.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        } else if (blockstate.is(ModTags.Blocks.LOGS_HALF)) {
            if (axis == Direction.Axis.X) {
                poseStack.mulPose(WoodProjectilefRenderer.mojandAxisFromDir(dir, isMirrored).rotationDegrees(angle));
            }
            if (axis == Direction.Axis.Z) {
                poseStack.mulPose(WoodProjectilefRenderer.mojandAxisFromDir(dir, !isMirrored).rotationDegrees(angle));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            if (isMirrored) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            if (dir.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0, -0.5, 0.0);
        poseStack.translate(-0.5, 0.0, -0.5);
        BakedModel model = this.dispatcher.getBlockModel(blockstate);
        BlockPos startPos = entity.getStartBlockpos();
        for (RenderType renderType : model.getRenderTypes(blockstate, RandomSource.create((long)blockstate.getSeed(startPos)), ModelData.EMPTY)) {
            this.dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)entity.level(), model, blockstate, entity.blockPosition().above(), poseStack, buffer.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType)), false, RandomSource.create(), blockstate.getSeed(startPos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AbstractWoodProjectile entity) {
        return TFCWoodworking.getResource("this_is_not_used_so_dont_care");
    }

    private static Axis mojandAxisFromDir(Direction dir, boolean isMirrored) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (isMirrored) {
                    yield Axis.YP;
                }
                yield Axis.YN;
            }
            case Direction.UP -> {
                if (isMirrored) {
                    yield Axis.YN;
                }
                yield Axis.YP;
            }
            case Direction.NORTH -> {
                if (isMirrored) {
                    yield Axis.ZP;
                }
                yield Axis.ZN;
            }
            case Direction.SOUTH -> {
                if (isMirrored) {
                    yield Axis.ZN;
                }
                yield Axis.ZP;
            }
            case Direction.WEST -> {
                if (isMirrored) {
                    yield Axis.XP;
                }
                yield Axis.XN;
            }
            case Direction.EAST -> isMirrored ? Axis.XN : Axis.XP;
        };
    }
}

