/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.datagen.recipes;

import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.tfcwoodwork.recipes.inworld.Action;
import su.uTa4u.tfcwoodwork.recipes.inworld.BlockStatePredicate;
import su.uTa4u.tfcwoodwork.recipes.inworld.InWorldRecipe;
import su.uTa4u.tfcwoodwork.recipes.inworld.SoundInstance;
import su.uTa4u.tfcwoodwork.recipes.inworld.Tool;

public final class InWorldRecipeBuilder
implements RecipeBuilder {
    @NotNull
    private final BlockStatePredicate inputState;
    @NotNull
    private final Tool tool;
    @NotNull
    private final BlockState resultState;
    @NotNull
    private final Optional<SoundInstance> sound;
    @NotNull
    private final List<Pair<ItemStack, Action>> resultItems;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public InWorldRecipeBuilder(@NotNull BlockStatePredicate inputState, @NotNull Tool tool, @NotNull BlockState resultState, @NotNull Optional<SoundInstance> sound, @NotNull List<Pair<ItemStack, Action>> resultItems) {
        this.inputState = inputState;
        this.tool = tool;
        this.resultState = resultState;
        this.sound = sound;
        this.resultItems = resultItems;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String group) {
        return this;
    }

    @NotNull
    public Item getResult() {
        return !this.resultItems.isEmpty() ? ((ItemStack)this.resultItems.getFirst().getFirst()).getItem() : Items.AIR;
    }

    public void save(@NotNull RecipeOutput output, @NotNull ResourceLocation id) {
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        InWorldRecipe recipe = new InWorldRecipe(this.inputState, this.tool, this.resultState, this.sound, this.resultItems);
        output.accept(id, (Recipe)recipe, null);
    }
}

