/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.entities;

import net.dries007.tfc.common.blocks.wood.Wood;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import su.uTa4u.tfcwoodwork.blockentities.LogPileExBlockEntity;
import su.uTa4u.tfcwoodwork.blocks.BlockType;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;
import su.uTa4u.tfcwoodwork.sounds.ModSounds;

public abstract class AbstractWoodProjectile
extends AbstractArrow {
    private static final String KEY_MIRRORED = "Mirrored";
    private static final String KEY_DIRECTION = "Direction";
    private static final String KEY_START_BLOCKPOS = "StartBlockpos";
    private static final String KEY_BLOCKSTATE = "Blockstate";
    private static final String KEY_HROT = "HRot";
    private static final EntityDataAccessor<Float> HROT = SynchedEntityData.defineId(AbstractWoodProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> MIRRORED = SynchedEntityData.defineId(AbstractWoodProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(AbstractWoodProjectile.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<BlockPos> START_BLOCKPOS = SynchedEntityData.defineId(AbstractWoodProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockState> BLOCKSTATE = SynchedEntityData.defineId(AbstractWoodProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final float DIM_SIZE = 0.375f;
    private static final EntityDimensions DIMENSIONS = new EntityDimensions(0.375f, 0.375f, 0.1875f, EntityAttachments.createDefault((float)0.375f, (float)0.375f), true);
    private static final int HOR_ROT_PERIOD = 30;
    private float hRot0 = 0.0f;

    protected AbstractWoodProjectile(EntityType<? extends AbstractWoodProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractWoodProjectile(EntityType<? extends AbstractWoodProjectile> entityType, BlockPos pos, BlockState state, double offsetX, double offsetY, double offsetZ, Level level, Direction dir, boolean isMirrored) {
        super(entityType, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, level, ItemStack.EMPTY, null);
        this.setMirrored(isMirrored);
        this.setDirection(dir);
        this.setStartBlockpos(pos);
        this.setBlockState(state);
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        this.setPickupItemStack(this.getBlockState().getBlock().asItem().getDefaultInstance());
    }

    public float getHRot() {
        return ((Float)this.entityData.get(HROT)).floatValue();
    }

    private void setHRot(float value) {
        this.entityData.set(HROT, (Object)Float.valueOf(value));
    }

    public float getHRot0() {
        return this.hRot0;
    }

    public void tick() {
        super.tick();
        this.hRot0 = this.getHRot();
        if (!this.inGround) {
            this.setHRot((float)(this.tickCount % 30) * 12.0f);
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HROT, (Object)Float.valueOf(0.0f));
        builder.define(MIRRORED, (Object)Boolean.FALSE);
        builder.define(DIRECTION, (Object)Direction.NORTH);
        builder.define(START_BLOCKPOS, (Object)BlockPos.ZERO);
        builder.define(BLOCKSTATE, (Object)((Block)ModBlocks.WOODS.get(Wood.ACACIA).get((Object)BlockType.DEBARKED_HALF).get()).defaultBlockState());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putFloat(KEY_HROT, this.getHRot());
        nbt.putBoolean(KEY_MIRRORED, this.getMirrored());
        nbt.putString(KEY_DIRECTION, this.getDirection().getName());
        nbt.put(KEY_START_BLOCKPOS, NbtUtils.writeBlockPos((BlockPos)this.getStartBlockpos()));
        nbt.putString(KEY_BLOCKSTATE, BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock()).toString());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setHRot(nbt.getFloat(KEY_HROT));
        this.setMirrored(nbt.getBoolean(KEY_MIRRORED));
        Direction dir = Direction.byName((String)nbt.getString(KEY_DIRECTION));
        if (dir != null) {
            this.setDirection(dir);
        }
        NbtUtils.readBlockPos((CompoundTag)nbt, (String)KEY_START_BLOCKPOS).ifPresent(this::setStartBlockpos);
        String state = nbt.getString(KEY_BLOCKSTATE);
        if (!state.isEmpty()) {
            this.setBlockState(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)state))).defaultBlockState());
        }
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(BLOCKSTATE);
    }

    private void setBlockState(BlockState state) {
        this.entityData.set(BLOCKSTATE, (Object)state);
    }

    public boolean getMirrored() {
        return (Boolean)this.entityData.get(MIRRORED);
    }

    private void setMirrored(boolean isMirrored) {
        this.entityData.set(MIRRORED, (Object)isMirrored);
    }

    @NotNull
    public Direction getDirection() {
        return (Direction)this.entityData.get(DIRECTION);
    }

    private void setDirection(Direction dir) {
        this.entityData.set(DIRECTION, (Object)dir);
    }

    public BlockPos getStartBlockpos() {
        return (BlockPos)this.entityData.get(START_BLOCKPOS);
    }

    private void setStartBlockpos(BlockPos pos) {
        this.entityData.set(START_BLOCKPOS, (Object)pos);
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)ModSounds.LOG_HIT_GROUND.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.hurt(this.damageSources().generic(), 1.0f);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        LogPileExBlockEntity logPileExBlockEntity;
        super.onHitBlock(result);
        Level level = this.level();
        BlockEntity blockEntity1 = level.getBlockEntity(result.getBlockPos());
        BlockEntity blockEntity2 = level.getBlockEntity(this.blockPosition());
        if (blockEntity1 instanceof LogPileExBlockEntity) {
            logPileExBlockEntity = (LogPileExBlockEntity)blockEntity1;
        } else if (blockEntity2 instanceof LogPileExBlockEntity) {
            logPileExBlockEntity = (LogPileExBlockEntity)blockEntity2;
        } else {
            return;
        }
        if (logPileExBlockEntity.insertItemStack(this.getPickupItem()).isEmpty()) {
            this.discard();
        }
    }

    @NotNull
    protected AABB makeBoundingBox() {
        return DIMENSIONS.makeBoundingBox(this.position());
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public float getPickRadius() {
        return 0.5f;
    }

    protected void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || this.getPickupItemStackOrigin().isEmpty()) {
            super.tickDespawn();
        }
    }
}

