/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.recipes.inworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import su.uTa4u.tfcwoodwork.TFCWoodworking;

public final class BlockStatePredicate
implements Predicate<BlockState> {
    public static final MapCodec<BlockStatePredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(BlockStatePredicate::getBlock), (App)BlockState.CODEC.listOf().optionalFieldOf("acceptableStates", List.of()).forGetter(BlockStatePredicate::getAcceptableStates)).apply((Applicative)inst, BlockStatePredicate::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockStatePredicate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), BlockStatePredicate::getBlock, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY)), BlockStatePredicate::getAcceptableStates, BlockStatePredicate::new);
    private final Block block;
    private final List<BlockState> acceptableStates;

    private BlockStatePredicate(Block block, List<BlockState> acceptableStates) {
        this.block = block;
        this.acceptableStates = acceptableStates;
    }

    public Block getBlock() {
        return this.block;
    }

    public List<BlockState> getAcceptableStates() {
        return this.acceptableStates;
    }

    @Override
    public boolean test(BlockState thatState) {
        if (!thatState.is(this.block)) {
            return false;
        }
        if (this.acceptableStates.isEmpty()) {
            return true;
        }
        return this.acceptableStates.contains(thatState);
    }

    public <T extends Comparable<T>> BlockStatePredicate where(Property<T> property, T value) {
        BlockState blockState = this.block.defaultBlockState();
        if (blockState.hasProperty(property)) {
            this.acceptableStates.add((BlockState)blockState.setValue(property, value));
        } else {
            TFCWoodworking.LOGGER.error("Tried to create BlockState for BlockStatePredicate with invalid property: " + String.valueOf(property));
        }
        return this;
    }

    public static BlockStatePredicate forBlock(Block block) {
        return new BlockStatePredicate(block, new ArrayList<BlockState>());
    }
}

