/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.recipes.inworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import su.uTa4u.tfcwoodwork.recipes.ModRecipeSerializers;
import su.uTa4u.tfcwoodwork.recipes.ModRecipeTypes;
import su.uTa4u.tfcwoodwork.recipes.inworld.Action;
import su.uTa4u.tfcwoodwork.recipes.inworld.BlockStatePredicate;
import su.uTa4u.tfcwoodwork.recipes.inworld.InWorldRecipeInput;
import su.uTa4u.tfcwoodwork.recipes.inworld.SoundInstance;
import su.uTa4u.tfcwoodwork.recipes.inworld.Tool;

public record InWorldRecipe(@NotNull BlockStatePredicate inputState, @NotNull Tool tool, @NotNull BlockState resultState, @NotNull Optional<SoundInstance> soundInstance, @NotNull List<Pair<ItemStack, Action>> resultItems) implements Recipe<InWorldRecipeInput>
{
    public static final String NAME = "in_world";

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.tool.getInputItem());
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public boolean matches(@NotNull InWorldRecipeInput input, @NotNull Level level) {
        return this.inputState.test(input.state()) && this.tool.getInputItem().test(input.stack());
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return !this.resultItems.isEmpty() ? (ItemStack)this.resultItems.getFirst().getFirst() : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack assemble(@NotNull InWorldRecipeInput input, @NotNull HolderLookup.Provider provider) {
        return this.getResultItem(provider).copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.IN_WORLD.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeTypes.IN_WORLD.get();
    }

    public static final class Serializer
    implements RecipeSerializer<InWorldRecipe> {
        private static final StreamCodec<RegistryFriendlyByteBuf, Pair<ItemStack, Action>> RESULT_ITEMS_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Pair<ItemStack, Action>>(){

            @NotNull
            public Pair<ItemStack, Action> decode(@NotNull RegistryFriendlyByteBuf input) {
                return Pair.of((Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)input)), (Object)((Object)((Action)((Object)Action.STREAM_CODEC.decode((Object)input)))));
            }

            public void encode(@NotNull RegistryFriendlyByteBuf output, @NotNull Pair<ItemStack, Action> pair) {
                ItemStack.STREAM_CODEC.encode((Object)output, (Object)((ItemStack)pair.getFirst()));
                Action.STREAM_CODEC.encode((Object)output, (Object)((Action)((Object)pair.getSecond())));
            }
        };
        public static final MapCodec<InWorldRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockStatePredicate.CODEC.fieldOf("inputState").forGetter(InWorldRecipe::inputState), (App)StringRepresentable.fromEnum(Tool::values).fieldOf("requiredTool").forGetter(InWorldRecipe::tool), (App)BlockState.CODEC.fieldOf("resultState").forGetter(InWorldRecipe::resultState), (App)SoundInstance.CODEC.optionalFieldOf("sound").forGetter(InWorldRecipe::soundInstance), (App)Codec.pair((Codec)ItemStack.CODEC.fieldOf("itemStack").codec(), (Codec)StringRepresentable.fromEnum(Action::values).fieldOf("action").codec()).listOf().optionalFieldOf("resultItems", List.of()).forGetter(InWorldRecipe::resultItems)).apply((Applicative)inst, InWorldRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InWorldRecipe> STREAM_CODEC = StreamCodec.composite(BlockStatePredicate.STREAM_CODEC, InWorldRecipe::inputState, Tool.STREAM_CODEC, InWorldRecipe::tool, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), InWorldRecipe::resultState, (StreamCodec)SoundInstance.STREAM_CODEC.apply(ByteBufCodecs::optional), InWorldRecipe::soundInstance, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, RESULT_ITEMS_STREAM_CODEC), InWorldRecipe::resultItems, InWorldRecipe::new);

        @NotNull
        public MapCodec<InWorldRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, InWorldRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

