/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.recipes.inworld;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.common.TFCTags;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public enum Tool implements StringRepresentable
{
    AXE("axe", (TagKey<Item>)ItemTags.AXES),
    SAW("saw", (TagKey<Item>)TFCTags.Items.TOOLS_SAW);

    public static final Tool[] VALUES;
    public static final StreamCodec<ByteBuf, Tool> STREAM_CODEC;
    private final String name;
    private final TagKey<Item> toolTagKey;
    private final Ingredient inputItem;
    private final String unlockedByName;

    private Tool(String name, TagKey<Item> toolTagKey) {
        this.name = name;
        this.toolTagKey = toolTagKey;
        this.inputItem = Ingredient.of(this.toolTagKey);
        this.unlockedByName = "has_" + this.name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public TagKey<Item> getToolTagKey() {
        return this.toolTagKey;
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public String getUnlockedByName() {
        return this.unlockedByName;
    }

    static {
        VALUES = Tool.values();
        STREAM_CODEC = ByteBufCodecs.idMapper(id -> VALUES[id], Enum::ordinal);
    }
}

