/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import su.uTa4u.tfcwoodwork.blockentities.BurningLogPileExBlockEntity;
import su.uTa4u.tfcwoodwork.blockentities.LogPileExBlockEntity;
import su.uTa4u.tfcwoodwork.blocks.LogPileExBlock;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;

public class BurningLogPileExBlock
extends Block
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_16;
    private static final int TICK_DELAY = 30;
    private final ExtendedProperties properties;

    public BurningLogPileExBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    public static void lightLogPile(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LogPileExBlockEntity) {
            LogPileExBlockEntity pile = (LogPileExBlockEntity)blockEntity;
            int logs = pile.logCount();
            BlockState state = level.getBlockState(pos);
            pile.clearContent();
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((Block)ModBlocks.BURNING_LOG_PILE_EX.get()).defaultBlockState().setValue(AXIS, (Comparable)((Direction.Axis)state.getValue(LogPileExBlock.AXIS)))).setValue((Property)COUNT, (Comparable)((Integer)state.getValue((Property)LogPileExBlock.COUNT))));
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.BLAZE_SHOOT);
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof BurningLogPileExBlockEntity) {
                BurningLogPileExBlockEntity burningPile = (BurningLogPileExBlockEntity)blockEntity2;
                burningPile.light(logs);
                BurningLogPileExBlock.tryLightNearby(level, pos);
            }
        }
    }

    public static void tryLightLogPile(Level level, BlockPos pos) {
        if (level.getBlockEntity(pos) instanceof LogPileExBlockEntity) {
            level.scheduleTick(pos, level.getBlockState(pos).getBlock(), 30);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AXIS}).add(new Property[]{COUNT}));
    }

    private static boolean isValidCoverBlock(BlockState offsetState, Level level, BlockPos pos, Direction side) {
        if (Helpers.isBlock((BlockState)offsetState, (TagKey)TFCTags.Blocks.CHARCOAL_PIT_INSULATION)) {
            return true;
        }
        return !offsetState.isFlammable((BlockGetter)level, pos, side) && offsetState.isFaceSturdy((BlockGetter)level, pos, side);
    }

    private static void tryLightNearby(Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (Direction side : Helpers.DIRECTIONS) {
                cursor.setWithOffset((Vec3i)pos, side);
                BlockState offsetState = level.getBlockState((BlockPos)cursor);
                if (BurningLogPileExBlock.isValidCoverBlock(offsetState, level, (BlockPos)cursor, side.getOpposite())) {
                    if (!Helpers.isBlock((BlockState)offsetState, (Block)((Block)ModBlocks.LOG_PILE_EX.get()))) continue;
                    BurningLogPileExBlock.tryLightLogPile(level, (BlockPos)cursor);
                    continue;
                }
                if (offsetState.isAir()) {
                    level.setBlockAndUpdate((BlockPos)cursor, Blocks.FIRE.defaultBlockState());
                    continue;
                }
                if (level.random.nextInt(7) != 0) continue;
                level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                return;
            }
        }
    }

    @NotNull
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BurningLogPileExBlock.tryLightNearby((Level)level, pos);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource rand) {
        if (level.getBlockState(pos.above(2)).canBeReplaced()) {
            double x = (float)pos.getX() + rand.nextFloat();
            double y = (float)pos.getY() + 1.125f;
            double z = (float)pos.getZ() + rand.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, (double)(0.1f + 0.1f * rand.nextFloat()), 0.0);
            if (rand.nextInt(12) == 0) {
                level.playLocalSound(x, y, z, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, (double)((0.5f - rand.nextFloat()) / 10.0f), (double)(0.1f + rand.nextFloat() / 8.0f), (double)((0.5f - rand.nextFloat()) / 10.0f));
        }
    }

    @NotNull
    protected VoxelShape getVisualShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return LogPileExBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }
}

