/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.compat.jei;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.tfcwoodwork.TFCWoodworking;
import su.uTa4u.tfcwoodwork.recipes.inworld.Action;
import su.uTa4u.tfcwoodwork.recipes.inworld.BlockStatePredicate;
import su.uTa4u.tfcwoodwork.recipes.inworld.InWorldRecipe;
import su.uTa4u.tfcwoodwork.recipes.inworld.Tool;

public final class InWorldRecipeCategory
implements IRecipeCategory<InWorldRecipe> {
    public static final Map<Tool, RecipeType<InWorldRecipe>> RECIPE_TYPES = Helpers.mapOf(Tool.class, tool -> RecipeType.create((String)"tfcwoodwork", (String)("in_world/" + tool.getSerializedName()), InWorldRecipe.class));
    private final Tool tool;
    private final Component title;
    private final IDrawable icon;
    private final IDrawable background;

    public InWorldRecipeCategory(IGuiHelper helper, Tool tool) {
        this.tool = tool;
        this.title = Component.translatable((String)("tfcwoodwork.jei.in_world." + this.tool.getSerializedName()));
        this.icon = helper.createDrawableItemLike((ItemLike)((Map)TFCItems.METAL_ITEMS.get(Metal.BLUE_STEEL)).get(Metal.ItemType.AXE));
        this.background = helper.createDrawable(TFCWoodworking.getResource("textures/gui/jei/in_world_recipe.png"), 0, 0, this.getWidth(), this.getHeight());
    }

    @NotNull
    public RecipeType<InWorldRecipe> getRecipeType() {
        return RECIPE_TYPES.get((Object)this.tool);
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull InWorldRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addInputSlot(22, 2).addIngredients(recipe.tool().getInputItem());
        BlockStatePredicate inputState = recipe.inputState();
        builder.addInputSlot(12, 40).addRichTooltipCallback((view, tooltip) -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            for (BlockState blockState : inputState.getAcceptableStates()) {
                for (Map.Entry<Property<?>, Comparable<?>> entry : blockState.getValues().entrySet()) {
                    lines.add(InWorldRecipeCategory.getPropertyValueName(entry));
                }
            }
            if (!lines.isEmpty()) {
                lines.addFirst(Component.translatable((String)"tfcwoodwork.jei.acceptable_states").append(":"));
                tooltip.addAll(lines);
            }
        }).addItemLike((ItemLike)inputState.getBlock());
        builder.addOutputSlot(51, 21).addItemLike((ItemLike)recipe.resultState().getBlock());
        List<Pair<ItemStack, Action>> resultItems = recipe.resultItems();
        int size = 2;
        for (int i = 0; i < 6; ++i) {
            int x = 71 + 19 * (i % 2);
            int y = 2 + 19 * Mth.floorDiv((int)i, (int)2);
            if (i >= resultItems.size()) break;
            Pair<ItemStack, Action> pair = resultItems.get(i);
            Action action = (Action)((Object)pair.getSecond());
            ItemStack itemStack = (ItemStack)pair.getFirst();
            builder.addOutputSlot(x, y).addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"tfcwoodwork.jei.itemstack_action").append(": ").append(action.getPrettyName()))).addItemStack(itemStack.copyWithCount(itemStack.getCount() * action.getCountFactor()));
        }
    }

    public void draw(@NotNull InWorldRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public int getWidth() {
        return 108;
    }

    public int getHeight() {
        return 58;
    }

    private static <T extends Comparable<T>> Component getPropertyValueName(Map.Entry<Property<?>, Comparable<?>> entry) {
        try {
            Property<?> property = entry.getKey();
            return Component.literal((String)("  " + property.getName() + " = " + property.getName(entry.getValue())));
        }
        catch (ClassCastException e) {
            return Component.empty();
        }
    }
}

