/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.datagen.recipes;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.tfcwoodwork.TFCWoodworking;
import su.uTa4u.tfcwoodwork.blocks.BlockType;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;
import su.uTa4u.tfcwoodwork.datagen.recipes.InWorldRecipeBuilder;
import su.uTa4u.tfcwoodwork.items.ModItems;
import su.uTa4u.tfcwoodwork.recipes.inworld.Action;
import su.uTa4u.tfcwoodwork.recipes.inworld.BlockStatePredicate;
import su.uTa4u.tfcwoodwork.recipes.inworld.SoundInstance;
import su.uTa4u.tfcwoodwork.recipes.inworld.Tool;
import su.uTa4u.tfcwoodwork.sounds.ModSounds;

public final class InWorldRecipeProvider
extends RecipeProvider {
    public InWorldRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        for (Wood wood : Wood.VALUES) {
            InWorldRecipeProvider.buildAxeRecipes(output, wood);
            InWorldRecipeProvider.buildSawRecipes(output, wood);
        }
    }

    private static void buildAxeRecipes(@NotNull RecipeOutput output, Wood wood) {
        Item bark = ModItems.getBark(wood);
        Item bast = ModItems.getBast(wood);
        InWorldRecipeProvider.buildRecipe(output, Tool.AXE, "strip_log/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.LOG)).where(BlockStateProperties.AXIS, Direction.Axis.Y), InWorldRecipeProvider.getState(wood, Wood.BlockType.STRIPPED_LOG), new SoundInstance(SoundEvents.AXE_STRIP, 1.0f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)bark, 1), (Object)((Object)Action.DROP_CARDINAL))));
        InWorldRecipeProvider.buildRecipe(output, Tool.AXE, "strip_wood/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.WOOD)), InWorldRecipeProvider.getState(wood, Wood.BlockType.STRIPPED_WOOD), new SoundInstance(SoundEvents.AXE_STRIP, 1.0f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)bark, 1), (Object)((Object)Action.DROP_CARDINAL)), Pair.of((Object)new ItemStack((ItemLike)bark, 2), (Object)((Object)Action.DROP_ABOVE))));
        InWorldRecipeProvider.buildRecipe(output, Tool.AXE, "debark_log/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.STRIPPED_LOG)).where(BlockStateProperties.AXIS, Direction.Axis.Y), InWorldRecipeProvider.getState(wood, BlockType.DEBARKED_LOG), new SoundInstance((SoundEvent)ModSounds.LOG_CHOP.get(), 0.6f, 0.8f), List.of(Pair.of((Object)new ItemStack((ItemLike)bast, 1), (Object)((Object)Action.DROP_CARDINAL))));
        InWorldRecipeProvider.buildRecipe(output, Tool.AXE, "debark_wood/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.STRIPPED_WOOD)), InWorldRecipeProvider.getState(wood, BlockType.DEBARKED_LOG), new SoundInstance((SoundEvent)ModSounds.LOG_CHOP.get(), 0.6f, 0.8f), List.of(Pair.of((Object)new ItemStack((ItemLike)bast, 1), (Object)((Object)Action.DROP_CARDINAL)), Pair.of((Object)new ItemStack((ItemLike)bast, 2), (Object)((Object)Action.DROP_ABOVE))));
        InWorldRecipeProvider.buildRecipe(output, Tool.AXE, "chop_log/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, BlockType.DEBARKED_LOG)), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_CHOP.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)InWorldRecipeProvider.getItem(wood, BlockType.DEBARKED_HALF), 1), (Object)((Object)Action.SHOOT_AS_BLOCK))));
        InWorldRecipeProvider.buildRecipe(output, Tool.AXE, "chop_log_half/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, BlockType.DEBARKED_HALF)), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_CHOP.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)InWorldRecipeProvider.getItem(wood, BlockType.DEBARKED_QUARTER), 1), (Object)((Object)Action.SHOOT_AS_BLOCK))));
    }

    private static void buildSawRecipes(@NotNull RecipeOutput output, Wood wood) {
        InWorldRecipeProvider.buildRecipe(output, Tool.SAW, "log_fence/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.LOG)).where(BlockStateProperties.AXIS, Direction.Axis.Y), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_SAWED.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)InWorldRecipeProvider.getItem(wood, Wood.BlockType.LOG_FENCE), 4), (Object)((Object)Action.DROP_CENTER)), Pair.of((Object)new ItemStack((ItemLike)ModItems.SAWDUST.get(), 1), (Object)((Object)Action.DROP_CENTER))));
        InWorldRecipeProvider.buildRecipe(output, Tool.SAW, "fence/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.PLANKS)), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_SAWED.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)InWorldRecipeProvider.getItem(wood, Wood.BlockType.FENCE), 4), (Object)((Object)Action.DROP_CENTER)), Pair.of((Object)new ItemStack((ItemLike)InWorldRecipeProvider.getItem(wood, Wood.BlockType.STAIRS), 1), (Object)((Object)Action.DROP_CENTER)), Pair.of((Object)new ItemStack((ItemLike)ModItems.SAWDUST.get(), 1), (Object)((Object)Action.DROP_CENTER))));
        InWorldRecipeProvider.buildRecipe(output, Tool.SAW, "trapdoor/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, Wood.BlockType.SLAB)), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_SAWED.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)InWorldRecipeProvider.getItem(wood, Wood.BlockType.TRAPDOOR), 2), (Object)((Object)Action.DROP_CENTER)), Pair.of((Object)new ItemStack((ItemLike)ModItems.SAWDUST.get(), 1), (Object)((Object)Action.DROP_CENTER))));
        InWorldRecipeProvider.buildRecipe(output, Tool.SAW, "support/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, BlockType.DEBARKED_HALF)), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_SAWED.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)TFCItems.SUPPORTS.get(wood), 4), (Object)((Object)Action.DROP_CENTER)), Pair.of((Object)new ItemStack((ItemLike)ModItems.SAWDUST.get(), 1), (Object)((Object)Action.DROP_CENTER))));
        InWorldRecipeProvider.buildRecipe(output, Tool.SAW, "lumber/" + wood.getSerializedName(), BlockStatePredicate.forBlock(InWorldRecipeProvider.getBlock(wood, BlockType.DEBARKED_QUARTER)), Blocks.AIR.defaultBlockState(), new SoundInstance((SoundEvent)ModSounds.LOG_SAWED.get(), 0.6f, 1.0f), List.of(Pair.of((Object)new ItemStack((ItemLike)TFCItems.LUMBER.get(wood), 2), (Object)((Object)Action.DROP_CENTER)), Pair.of((Object)new ItemStack((ItemLike)ModItems.SAWDUST.get(), 1), (Object)((Object)Action.DROP_CENTER))));
    }

    private static void buildRecipe(@NotNull RecipeOutput output, @NotNull Tool tool, @NotNull String recipeName, @NotNull BlockStatePredicate inputState, @NotNull BlockState resultState, @Nullable SoundInstance sound, @NotNull List<Pair<ItemStack, Action>> resultItems) {
        ResourceLocation id = TFCWoodworking.getResource("in_world/" + tool.getSerializedName() + "/" + recipeName);
        new InWorldRecipeBuilder(inputState, tool, resultState, Optional.ofNullable(sound), resultItems).unlockedBy(tool.getUnlockedByName(), InWorldRecipeProvider.has(tool.getToolTagKey())).save(output, id);
    }

    private static Block getBlock(Wood wood, Wood.BlockType type) {
        return (Block)((TFCBlocks.Id)((Map)TFCBlocks.WOODS.get(wood)).get(type)).get();
    }

    private static Block getBlock(Wood wood, BlockType type) {
        return (Block)ModBlocks.WOODS.get(wood).get((Object)type).get();
    }

    private static BlockState getState(Wood wood, Wood.BlockType type) {
        return InWorldRecipeProvider.getBlock(wood, type).defaultBlockState();
    }

    private static BlockState getState(Wood wood, BlockType type) {
        return InWorldRecipeProvider.getBlock(wood, type).defaultBlockState();
    }

    private static Item getItem(Wood wood, Wood.BlockType type) {
        return InWorldRecipeProvider.getState(wood, type).getBlock().asItem();
    }

    private static Item getItem(Wood wood, BlockType type) {
        return InWorldRecipeProvider.getState(wood, type).getBlock().asItem();
    }
}

