/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.items;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import su.uTa4u.tfcwoodwork.TFCWoodworking;
import su.uTa4u.tfcwoodwork.items.SawdustSoupBowl;

public final class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"tfcwoodwork");
    public static final Map<Wood, DeferredHolder<Item, Item>> TREE_BARK = Helpers.mapOf(Wood.class, wood -> ModItems.registerItem("bark/" + wood.name(), () -> new Item(new Item.Properties())));
    public static final Map<Wood, DeferredHolder<Item, Item>> TREE_BAST = Helpers.mapOf(Wood.class, wood -> ModItems.registerItem("bast/" + wood.name(), () -> new Item(new Item.Properties())));
    public static final DeferredHolder<Item, Item> SAWDUST = ModItems.registerItem("sawdust", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SAWDUST_SOUP = ModItems.registerItem("sawdust_soup", () -> new SawdustSoupBowl(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SAWDUST_DOUGH = ModItems.registerItem("sawdust_dough", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SAWDUST_BREAD = ModItems.registerItem("sawdust_bread", () -> new Item(new Item.Properties()));

    private ModItems() {
    }

    private static DeferredHolder<Item, Item> registerItem(String name, Supplier<Item> itemSup) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), itemSup);
    }

    public static Item getBark(Wood wood) {
        return (Item)BuiltInRegistries.ITEM.get(TFCWoodworking.getResource("bark/" + wood.name().toLowerCase(Locale.ROOT)));
    }

    public static Item getBast(Wood wood) {
        return (Item)BuiltInRegistries.ITEM.get(TFCWoodworking.getResource("bast/" + wood.name().toLowerCase(Locale.ROOT)));
    }
}

