#version 120

uniform sampler2D texture;

varying vec2 texcoord;
varying vec4 glcolor;

void main() {
	vec4 color = texture2D(texture, texcoord) * glcolor;
	
	// Fix for pink world border - replace magenta with natural cloud color
	if (color.r > 0.9 && color.g < 0.1 && color.b > 0.9) {
		color = vec4(1.0, 1.0, 1.0, color.a); // Natural white clouds
	}

/* DRAWBUFFERS:0 */
	gl_FragData[0] = color; //gcolor
}