# VFX Shader Pack Settings Guide

## Accessing Shader Settings

To access the shader settings in Minecraft with Iris Shaders:

1. Open Minecraft with Iris Shaders installed
2. Go to Options > Video Settings
3. Click on "Shader Packs..."
4. Select the VFX shader pack
5. Click the "Shader Pack Settings" button (gear icon)

If you don't see the settings button:
- Make sure you're using the latest version of Iris Shaders
- Try clicking the "Import settings from file" button and select the shader_options.txt file in the shader pack folder

## Available Settings

### Main Settings
- **Entity Shadows**: Toggle shadows cast by entities (mobs, players, etc.)
- **Waving Speed**: Control how fast vegetation waves in the wind

### Shadow Settings
- **Shadow Quality**: Adjust the quality of shadows (Low/Medium/High)

### Vegetation Settings
- **Waving Plants**: Toggle vegetation movement
- **Waving Speed**: Control how fast vegetation waves in the wind

### Performance Settings
- **Shadow Quality**: Adjust the quality of shadows for performance

## Troubleshooting

If settings aren't appearing or working correctly:

1. Make sure you have the latest version of Iris Shaders installed
2. Try restarting Minecraft after installing the shader pack
3. Check that the shader pack is properly installed in the shaderpacks folder
4. If using OptiFine instead of Iris, some settings may not be available

## Manual Configuration

If the UI doesn't work, you can manually edit these files:

- `settings.txt`: Contains the current shader settings
- `shader_options.txt`: Defines the available options
- `shaders.config`: Stores your configuration

After editing, restart Minecraft or reload shaders for changes to take effect.