#version 120

// ===== TEXTURED LIT FRAGMENT SHADER =====
// Enhanced lighting for light-emitting blocks like torches, glowstone

uniform sampler2D lightmap;
uniform sampler2D texture;
uniform float frameTimeCounter;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;

void main() {
    vec4 color = texture2D(texture, texcoord) * glcolor;
    
    // Fix for pink world border - better handling with sky blend
    if (color.r > 0.8 && color.g < 0.2 && color.b > 0.8 && color.a > 0.9) {
        color = vec4(0.5, 0.7, 1.0, 1.0) * 0.8; // Sky blue tint
    }
    
    vec4 lightmapColor = texture2D(lightmap, lmcoord);
    
    // Apply basic lighting
    color *= lightmapColor;
    
    // Add very subtle flickering to light sources
    float flicker = 1.0 + sin(frameTimeCounter * 6.0) * 0.03;
    color.rgb *= flicker;
    
    // Add subtle warm glow
    color.rgb += vec3(0.02, 0.01, 0.005);

/* DRAWBUFFERS:0 */
    gl_FragData[0] = color;                           // Color to colortex0
}