#version 120

// ===== SIMPLE WATER FRAGMENT SHADER =====
// Subtle water improvements without breaking everything

uniform sampler2D lightmap;
uniform sampler2D texture;
uniform float frameTimeCounter;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;
varying vec3 worldPos;

void main() {
    // Basic water rendering
    vec4 color = texture2D(texture, texcoord) * glcolor;
    
    // Fix for pink world border
    if (color.r > 0.9 && color.g < 0.1 && color.b > 0.9) {
        color = vec4(0.2, 0.4, 0.8, 0.8); // Natural water blue
    }
    
    // Apply basic lighting
    color *= texture2D(lightmap, lmcoord);
    
    // Add very subtle water animation
    float time = frameTimeCounter * 0.3;
    float wave = sin(time + worldPos.x * 0.1 + worldPos.z * 0.1) * 0.05 + 1.0;
    color.rgb *= wave;
    
    // Slight blue tint for water
    if (color.a < 0.99) { // Only for transparent water
        color.rgb = mix(color.rgb, vec3(0.3, 0.5, 0.8), 0.2);
    }

/* DRAWBUFFERS:0 */
    gl_FragData[0] = color;                           // Color to colortex0
}