#version 120

// ===== ENTITIES VERTEX SHADER =====
// For mobs, items, etc. with subtle animation

uniform float frameTimeCounter;
uniform vec3 cameraPosition;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;
varying vec3 worldPos;
varying vec4 shadowPos;

uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

// ===== ENTITY ANIMATION SETTINGS =====
const float ENTITY_SWAY = 0.01;  // Subtle swaying for items/mobs

void main() {
    vec4 position = gl_Vertex;
    
    // Calculate world position
    worldPos = position.xyz + cameraPosition;
    
    // Add very subtle swaying to entities (like dropped items)
    float time = frameTimeCounter * 0.8;
    float sway = sin(time + worldPos.x * 0.1) * cos(time * 0.7 + worldPos.z * 0.1);
    position.x += sway * ENTITY_SWAY;
    
    vec4 viewPos = gl_ModelViewMatrix * position;
    shadowPos = shadowProjection * (shadowModelView * viewPos);
    // Simple distortion fix for shadow map
    float distortFactor = 1.0 / (length(shadowPos.xy) * 0.1 + 0.9);
    shadowPos.xy *= distortFactor;
    gl_Position = ftransform();
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
}