#version 120

// ===== SIMPLE SHADOW VERTEX SHADER =====
// Basic shadow mapping without complex distortion

// Input attributes
attribute vec4 mc_Entity;

// Uniforms
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

// Configuration
#define ENTITY_SHADOWS 0  // Disabled entity shadows

// Varying outputs
varying vec2 texcoord;
varying vec4 glcolor;

void main() {
    vec4 position = gl_Vertex;
    
    // Pass through texture coordinates and color
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    glcolor = gl_Color;
    
    // Skip entity rendering in shadow pass
    // Entity IDs are typically > 10000 for entities
    // Common entity IDs: players, mobs, items, etc.
    if (ENTITY_SHADOWS == 0 && (mc_Entity.x >= 10000.0 || mc_Entity.x == 0.0)) {
        // Move entities far away to effectively remove their shadows
        // Using a very large value to ensure they're completely out of view
        gl_Position = vec4(100000.0, 100000.0, 100000.0, 1.0);
        return;
    }
    
    // Transform to shadow space (only terrain and blocks)
    gl_Position = shadowProjection * shadowModelView * position;
}