# VFX Simple Shader Pack - Settings Guide

## Accessing Shader Settings

To access the shader settings UI in Minecraft:

1. Press **ESC** to open the game menu
2. Click on **Options**
3. Click on **Video Settings**
4. Click on **Shader Packs**
5. Select **VFX Simple Shader Pack** from the list
6. Click on **Shader Pack Settings** button

## Available Settings Categories

The shader settings are organized into the following categories:

### World
- **Waving Plants**: Enables or disables vegetation movement
- **Waving Speed**: Controls how fast vegetation waves in the wind

### Atmosphere
- **Volumetric Light**: Enables volumetric lighting effects (god rays)

### Water
- **Water Waves**: Enables animated waves on water surfaces
- **Water Reflections**: Controls the quality of reflections on water surfaces

### Sky
- **Sky Quality**: Adjusts the visual quality of the sky

### Materials
- **Material Format**: Changes how material properties are rendered

### Shadows
- **Entity Shadows**: Enables or disables shadows cast by entities (mobs, players, etc.)
- **Shadow Quality**: Adjusts the quality of shadows

### Camera
- **Depth of Field**: Enables depth of field effect for a more cinematic look

### Effects
- **Bloom Effect**: Adds a glow effect to bright light sources

## Troubleshooting

If you're having trouble accessing the shader settings:

1. Make sure you're using the latest version of Iris Shaders or OptiFine
2. Try restarting Minecraft after installing the shader pack
3. Check that you've selected the shader pack in the Shader Packs menu
4. If settings don't appear, try manually editing the configuration files (see below)

## Manual Configuration

If you need to manually configure the shader settings, you can edit the following files in the shader pack folder:

- `settings.txt`: Contains default values for all settings
- `shader_options.txt`: Defines the available options and their values
- `shaders.config`: Used by Iris Shaders to save and load settings
- `optifine.properties`: Used by OptiFine to save and load settings

These files can be found in the shader pack folder, which is typically located at:
- Windows: `%appdata%\.minecraft\shaderpacks\vfx-simple_preview2_particales\shaders\`
- macOS: `~/Library/Application Support/minecraft/shaderpacks/vfx-simple_preview2_particales/shaders/`
- Linux: `~/.minecraft/shaderpacks/vfx-simple_preview2_particales/shaders/`

## Performance Tips

If you're experiencing performance issues, try adjusting these settings:

1. Lower **Shadow Quality** to improve performance
2. Disable **Bloom Effect** for a performance boost
3. Disable **Volumetric Light** if you're experiencing significant lag
4. Set **Material Format** to Basic for better performance on older hardware

## Recommended Settings

For the best visual experience with good performance:

- **Shadow Quality**: Medium
- **Volumetric Light**: On
- **Water Reflections**: Basic
- **Bloom Effect**: On
- **Depth of Field**: Off (unless taking screenshots)

## Feedback and Support

If you encounter any issues or have suggestions for improvement, please contact the shader pack author through the official distribution channels.

---

*This guide is for VFX Simple Shader Pack v1.3*