# VFX Simple - Version 1.3

A Minecraft shader pack developed by BunnyCrop Studios that enhances your gameplay experience with beautiful visual effects while maintaining performance.

## Features

- Enhanced lighting and shadows
- Improved sky and water rendering
- Subtle particle effects
- Optimized for performance
- Fixed pink world border with sky blending
- Improved player shadow rendering
- Configurable vegetation waving
- Entity shadow controls

## Installation

1. Download the shader pack
2. Place it in your Minecraft shaderpacks folder
3. Select it in Video Settings > Shaders

## Configuration

This shader pack includes a comprehensive configuration UI that allows you to customize various aspects of the visual experience.

### Accessing the Configuration UI
1. In Minecraft, go to Video Settings > Shader Packs
2. Select the shader pack and click "Shader Pack Settings" (gear icon)

**Note:** If you don't see the settings button or options aren't appearing:
- Make sure you're using the latest version of Iris Shaders
- Try clicking the "Import settings from file" button and select the `shader_options.txt` file in the shader pack folder
- Alternatively, you can manually edit the configuration files in the shader pack directory

### Settings Categories
The configuration is organized into several categories:

#### World
- **Waving Plants**: Toggle the waving effect for plants
- **Waving Speed**: Adjust the speed of waving vegetation

#### Atmosphere
- **Volumetric Light**: Toggle volumetric lighting effects (god rays)

#### Water
- **Water Waves**: Toggle animated waves on water surfaces
- **Water Reflections**: Adjust the quality of reflections on water

#### Sky
- **Sky Quality**: Adjust the visual quality of the sky

#### Materials
- **Material Format**: Change how material properties are rendered

#### Shadows
- **Entity Shadows**: Toggle shadows for entities (players, mobs, items)
- **Shadow Quality**: Adjust the quality of shadows (Low/Medium/High)

#### Camera
- **Depth of Field**: Toggle depth of field effect for a cinematic look

#### Effects
- **Bloom Effect**: Toggle glow effect on bright light sources

## Troubleshooting

### Black Shadow Artifacts on Entities
If you experience black shadow artifacts on entities (players, mobs):
1. Go to Shader Pack Settings
2. Set "Entity Shadows" to OFF

### Performance Issues
If you experience performance issues:
1. Lower the Shadow Quality setting
2. Disable Volumetric Light
3. Set Water Reflections to Off or Basic
4. Disable Bloom Effect
5. Disable Waving Plants if necessary

## Compatibility
- Minecraft 1.20.1 and above
- Works with Iris Shaders and OptiFine

## Manual Configuration

If the shader settings UI doesn't work properly, you can manually edit these files in the shader pack folder:

- `settings.txt`: Contains the current shader settings
- `shader_options.txt`: Defines the available options
- `shaders.config`: Stores your configuration
- `iris_options.json`: Configuration file specifically for Iris Shaders

After editing any of these files, restart Minecraft or reload shaders for changes to take effect.

For detailed instructions, see the `SETTINGS_GUIDE.md` file included in the shader pack.

## Beta Notice

This is a beta build. Please report any bugs or issues to BunnyCrop Studios.