# Warm Vanilla+ Shader Pack Installation Guide

## Requirements
- Minecraft Java Edition 1.20.1
- Iris Shaders mod (recommended) or OptiFine
- Mid-range graphics card (GTX 1060 / RX 580 or better)

## Installation Steps

### Method 1: Using Iris Shaders (Recommended)
1. Install Fabric Loader for Minecraft 1.20.1
2. Download and install Iris Shaders mod from Modrinth or CurseForge
3. Launch Minecraft and go to Options > Video Settings > Shader Packs
4. Click "Open Shader Pack Folder"
5. Copy the entire shader folder into the `shaderpacks` directory
6. Select "Warm Vanilla+" from the shader list
7. Click "Done" to apply

### Method 2: Using OptiFine
1. Install OptiFine for Minecraft 1.20.1
2. Launch Minecraft and go to Options > Video Settings > Shaders
3. Click "Shaders Folder"
4. Copy the entire shader folder into the `shaderpacks` directory
5. Select "Warm Vanilla+" from the shader list
6. Click "Done" to apply

## Folder Structure
Your shaderpacks folder should look like this:
```
shaderpacks/
└── WarmVanillaPlus/
    ├── shaders.properties
    ├── gbuffers_terrain.vsh
    ├── gbuffers_terrain.fsh
    ├── gbuffers_water.vsh
    ├── gbuffers_water.fsh
    ├── composite.vsh
    ├── composite.fsh
    └── [other existing shader files]
```

## Customization
You can edit the following values in the shader files to customize the look:

### In `gbuffers_terrain.vsh`:
- `GRASS_WAVE_STRENGTH`: Controls grass waving intensity (default: 0.05)
- `LEAF_WAVE_STRENGTH`: Controls leaf waving intensity (default: 0.03)
- `WAVE_SPEED`: Controls animation speed (default: 1.0)

### In `composite.fsh`:
- `WARM_TINT`: RGB values for warm color tint (default: 1.05, 1.02, 0.95)
- `CONTRAST`: Overall contrast adjustment (default: 1.05)
- `SATURATION`: Color saturation boost (default: 1.1)
- `RIPPLE_STRENGTH`: Water ripple intensity (default: 0.002)

### In `gbuffers_water.vsh`:
- `WATER_WAVE_HEIGHT`: Height of water surface waves (default: 0.02)
- `WATER_WAVE_SPEED`: Speed of water animation (default: 1.0)

## Performance Tips
- If you experience low FPS, try reducing shadow resolution in shader settings
- Disable other resource packs that might conflict
- Lower render distance if needed
- The shader is optimized for 60+ FPS on mid-range hardware

## Troubleshooting
- **Black screen**: Make sure all shader files are in the correct folder
- **No animation**: Check that frameTimeCounter is working (restart Minecraft)
- **Too warm/cold**: Adjust WARM_TINT values in composite.fsh
- **Performance issues**: Lower shadow settings or render distance

Enjoy your warm, animated Minecraft world!