#version 120

uniform sampler2D lightmap;
uniform sampler2D texture;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;

void main() {
	vec4 color = texture2D(texture, texcoord) * glcolor;
	
	// Fix for pink world border - better handling with sky blend
	if (color.r > 0.8 && color.g < 0.2 && color.b > 0.8 && color.a > 0.9) {
		color = vec4(0.5, 0.7, 1.0, 1.0) * 0.8; // Sky blue tint
	}
	
	color *= texture2D(lightmap, lmcoord);

/* DRAWBUFFERS:0 */
	gl_FragData[0] = color; //gcolor
}