#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;

varying vec2 texcoord;
varying vec4 glcolor;

void main() {
    vec4 color = texture2D(texture, texcoord) * glcolor;
    
    // Fix for pink world border - better handling with sky blend
    if (color.r > 0.8 && color.g < 0.2 && color.b > 0.8 && color.a > 0.9) {
        color = vec4(0.5, 0.7, 1.0, 1.0) * 0.8; // Sky blue tint
    }
    
    if (color.a < 0.01) discard;
    
    // Apply basic lighting
    color.rgb *= texture2D(lightmap, vec2(0.5, 0.5)).rgb;
    
/* DRAWBUFFERS:0 */
    gl_FragData[0] = color;
}