#version 120

// ===== PARTICLE VERTEX SHADER =====
// Handles torch particles and fog effects

// Input attributes
attribute vec4 mc_Entity;

// Uniforms
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjection;
uniform mat4 gbufferModelViewInverse;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

// Varying outputs
varying vec2 texcoord;
varying vec4 glcolor;
varying vec3 worldPos;
varying float particleType;

void main() {
    vec4 position = gl_Vertex;
    
    // Pass through basic data
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    glcolor = gl_Color;
    particleType = mc_Entity.x;
    
    // Calculate world position
    vec4 worldPosition = gbufferModelViewInverse * (gl_ModelViewMatrix * position);
    worldPos = worldPosition.xyz;
    
    // Enhanced particle effects
    if (particleType > 0.0) {
        // Add slight movement to particles
        float time = frameTimeCounter * 2.0;
        float particlePhase = (worldPos.x + worldPos.z) * 0.1;
        
        // Gentle floating motion for torch particles
        position.y += sin(time + particlePhase) * 0.02;
        position.x += cos(time * 0.7 + particlePhase) * 0.01;
    }
    
    gl_Position = gbufferProjection * gbufferModelView * position;
}