#version 120

// ===== ENHANCED SKY FRAGMENT SHADER =====
// Custom sky with stars, aurora, and enhanced clouds

uniform int worldTime;
uniform float frameTimeCounter;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

varying vec4 glcolor;
varying vec2 texcoord;

// ===== SKY EFFECT SETTINGS =====
const float STAR_DENSITY = 0.8;        // How many stars appear
const float AURORA_INTENSITY = 0.6;    // Aurora brightness
const float CLOUD_COVERAGE = 0.4;      // Cloud density

// Simple noise function for effects
float noise(vec2 p) {
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
    vec4 color = glcolor;
    
    // Fix for pink world border - replace magenta with natural sky color
    if (color.r > 0.9 && color.g < 0.1 && color.b > 0.9) {
        color = vec4(0.7, 0.8, 0.9, 1.0); // Natural sky blue
    }
    
    float timeOfDay = float(worldTime % 24000) / 24000.0;
    bool isNight = (timeOfDay > 0.85 || timeOfDay < 0.15);
    bool isDusk = (timeOfDay > 0.75 && timeOfDay < 0.85) || (timeOfDay > 0.15 && timeOfDay < 0.25);
    
    // ===== SIMPLE STARS =====
    if (isNight) {
        vec2 starCoord = texcoord * 30.0;
        float starNoise = noise(floor(starCoord));
        
        // Simple stars
        if (starNoise > 0.98) {
            float twinkle = sin(frameTimeCounter * 2.0 + starNoise * 5.0) * 0.2 + 0.8;
            color.rgb += vec3(1.0, 0.9, 0.8) * 0.5 * twinkle;
        }
    }
    
    // ===== SUBTLE SKY TINTING =====
    if (isDusk) {
        // Gentle golden hour
        color.r *= 1.1;
        color.g *= 1.05;
        color.b *= 0.95;
    } else if (isNight) {
        // Subtle night tint
        color.rgb *= vec3(0.7, 0.8, 1.0);
    } else {
        // Very subtle warm tint during day
        color.rgb *= vec3(1.02, 1.01, 0.99);
    }

/* DRAWBUFFERS:0 */
    gl_FragData[0] = color;
}