#version 120

// ===== TEXTURED LIT VERTEX SHADER =====
// For light-emitting blocks like torches, glowstone, etc.

uniform float frameTimeCounter;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;
varying vec3 worldPos;

void main() {
    vec4 position = gl_Vertex;
    
    // Calculate world position for effects
    worldPos = position.xyz;
    
    // Add subtle flickering to light sources
    float flicker = sin(frameTimeCounter * 6.0 + worldPos.x + worldPos.z) * 0.02;
    position.y += flicker;
    
    gl_Position = ftransform();
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
}