#version 120

// ===== SIMPLE WATER VERTEX SHADER =====
// Subtle water animation without breaking everything

uniform mat4 gbufferModelViewInverse;
uniform float frameTimeCounter;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 glcolor;
varying vec3 worldPos;

void main() {
    vec4 position = gl_Vertex;
    
    // Calculate world position for animation
    vec4 worldPosition = gbufferModelViewInverse * (gl_ModelViewMatrix * position);
    worldPos = worldPosition.xyz;
    
    // Very subtle wave animation (much smaller than before)
    float time = frameTimeCounter * 0.5;
    float wave = sin(time + worldPos.x * 0.2 + worldPos.z * 0.2) * 0.005;
    position.y += wave;
    
    gl_Position = ftransform();
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
}