#version 120

// ===== SIMPLE SHADOW FRAGMENT SHADER =====
// Basic depth rendering for shadows

// Configuration
#define ENTITY_SHADOWS 0  // Disabled entity shadows (must match shadow.vsh)

#ifndef SHADOW_QUALITY
    #define SHADOW_QUALITY 1  // Default: Medium quality
#endif

// Uniforms
uniform sampler2D texture;
uniform int entityId;

// Varying inputs
varying vec2 texcoord;
varying vec4 glcolor;

void main() {
    // Skip entity rendering in shadow pass if disabled
    if (ENTITY_SHADOWS == 0 && entityId >= 10000) {
        discard; // Don't render entity shadows
        return;
    }
    
    // Sample texture
    vec4 color = texture2D(texture, texcoord) * glcolor;
    
    // Discard transparent pixels
    if (color.a < 0.5) discard;
    
    // Simple depth output
    gl_FragColor = vec4(1.0);
}