/*
 * Decompiled with CFR 0.152.
 */
package io.github.rektroth.whiteout.mixin;

import com.google.common.collect.ImmutableMap;
import io.github.rektroth.whiteout.Whiteout;
import io.github.rektroth.whiteout.config.Option;
import io.github.rektroth.whiteout.config.WhiteoutConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class WhiteoutMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "io.github.rektroth.whiteout.mixin.";
    private final Logger logger = LogManager.getLogger((String)"Whiteout");
    private static final Supplier<Boolean> TRUE = () -> true;
    private static final Map<String, Supplier<Boolean>> CONDITIONS = ImmutableMap.of((Object)"nethervoiddamage.compat.lithium.LithiumCompatPortalForcerMixin", () -> FabricLoader.getInstance().isModLoaded("lithium"), (Object)"nethervoiddamage.PortalForcerMixin", () -> !FabricLoader.getInstance().isModLoaded("lithium"), (Object)"mc27056.compat.lithium.LithiumCompatExplosionImplMixin", () -> FabricLoader.getInstance().isModLoaded("lithium"), (Object)"mc27056.ExplosionImplMixin", () -> !FabricLoader.getInstance().isModLoaded("lithium"));
    private WhiteoutConfig config;

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(MIXIN_PACKAGE_ROOT)) {
            this.logger.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        if (!CONDITIONS.getOrDefault(mixin, TRUE).get().booleanValue()) {
            return false;
        }
        Option option = this.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            this.logger.error("No rules matched mixin '{}', treating as foreign and disabling!", (Object)mixin);
            return false;
        }
        if (option.isOverridden()) {
            Object source = "[unknown]";
            if (option.isUserDefined()) {
                source = "user configuration";
            } else if (option.isModDefined()) {
                source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
            }
            if (option.isEnabled()) {
                this.logger.warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", (Object)mixin, (Object)option.getName(), source);
            } else {
                this.logger.warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", (Object)mixin, (Object)option.getName(), source);
            }
        }
        return option.isEnabled();
    }

    public void onLoad(String mixinPackage) {
        try {
            this.config = WhiteoutConfig.load(new File("./config/whiteout.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load configuration file for Whiteout", e);
        }
        this.logger.info("Loaded configuration file for Whiteout: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
        Whiteout.CONFIG = this.config;
    }

    public String getRefMapperConfig() {
        return "";
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

