/*
 * Decompiled with CFR 0.152.
 */
package io.github.rektroth.whiteout.config;

import io.github.rektroth.whiteout.config.Option;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WhiteoutConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"WhiteoutConfig");
    private static final String JSON_KEY_WHITEOUT_OPTIONS = "whiteout:options";
    private final Map<String, Option> options = new HashMap<String, Option>();
    private final Set<Option> optionsWithDependencies = new ObjectLinkedOpenHashSet();

    private WhiteoutConfig() {
        InputStream defaultPropertiesStream = WhiteoutConfig.class.getResourceAsStream("/assets/whiteout/whiteout-mixin-config-default.properties");
        if (defaultPropertiesStream == null) {
            throw new IllegalStateException("Whiteout mixin config default properties could not be read!");
        }
        try (BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(defaultPropertiesStream));){
            Properties properties = new Properties();
            properties.load(propertiesReader);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(ruleName, enabled) -> this.addMixinRule((String)ruleName, Boolean.parseBoolean((String)enabled))));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Whiteout mixin config default properties could not be read!");
        }
    }

    public static WhiteoutConfig load(File file) {
        WhiteoutConfig config = new WhiteoutConfig();
        if (file.exists()) {
            Properties props = new Properties();
            try (FileInputStream fin = new FileInputStream(file);){
                props.load(fin);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load config file", e);
            }
            config.readProperties(props);
        } else {
            try {
                WhiteoutConfig.writeDefaultConfig(file);
            }
            catch (IOException e) {
                LOGGER.warn("Could not write default configuration file", (Throwable)e);
            }
        }
        config.applyModOverrides();
        return config;
    }

    private void addMixinRule(String mixin, boolean enabled) {
        if (this.options.putIfAbsent(mixin, new Option(mixin, enabled, false)) != null) {
            throw new IllegalStateException("Mixin rule already defined: " + mixin);
        }
    }

    private void readProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    private void applyModOverrides() {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = container.getMetadata();
            if (!meta.containsCustomValue(JSON_KEY_WHITEOUT_OPTIONS)) continue;
            CustomValue overrides = meta.getCustomValue(JSON_KEY_WHITEOUT_OPTIONS);
            if (overrides.getType() != CustomValue.CvType.OBJECT) {
                LOGGER.warn("Mod '{}' contains invalid Whiteout option overrides, ignoring", (Object)meta.getId());
                continue;
            }
            for (Map.Entry entry : overrides.getAsObject()) {
                this.applyModOverride(meta, (String)entry.getKey(), (CustomValue)entry.getValue());
            }
        }
    }

    private void applyModOverride(ModMetadata meta, String name, CustomValue value) {
        Option option = this.options.get(name);
        if (option == null) {
            LOGGER.warn("Mod '{}' attempted to override option '{}', which doesn't exist, ignoring", (Object)meta.getId(), (Object)name);
            return;
        }
        if (value.getType() != CustomValue.CvType.BOOLEAN) {
            LOGGER.warn("Mod '{}' attempted to override option '{}' with an invalid value, ignoring", (Object)meta.getId(), (Object)name);
            return;
        }
        boolean enabled = value.getAsBoolean();
        if (!enabled && option.isEnabled()) {
            option.clearModsDefiningValue();
        }
        if (!enabled || option.isEnabled() || option.getDefiningMods().isEmpty()) {
            option.addModOverride(enabled, meta.getId());
        }
    }

    public Option getEffectiveOptionForMixin(String mixinClassName) {
        String key = mixinClassName.substring(0, mixinClassName.indexOf(46));
        return this.options.get(key);
    }

    private static void writeDefaultConfig(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("# This is the configuration file for Whiteout.\n");
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isOverridden).count();
    }

    public boolean isCompatMixin(String mixinClassName) {
        String key = mixinClassName.substring(0, mixinClassName.indexOf(46));
        return key.equals("compat");
    }

    public String getCompatMod(String mixinClassName) {
        if (this.isCompatMixin(mixinClassName)) {
            String key = mixinClassName.substring(0, mixinClassName.indexOf(46));
            return mixinClassName.substring((key + ".compat.").length(), mixinClassName.indexOf(46));
        }
        return null;
    }
}

