/*
 * Decompiled with CFR 0.152.
 */
package dev.alphacerium.advancedgroups;

import de.maxhenkel.admiral.permissions.PermissionManager;
import dev.alphacerium.advancedgroups.AdvancedGroupCommands;
import java.util.List;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class AdvancedGroupPermissionManager
implements PermissionManager<class_2168> {
    private final List<Permission> PERMISSIONS;
    private static Boolean loaded;

    public AdvancedGroupPermissionManager() {
        Permission PUSH_GROUP_PERMISSION = new Permission("advancedgroups.push_group", AdvancedGroupCommands.CONFIG.pushGroupPermissionType.get());
        Permission RELEASE_GROUP_PERMISSION = new Permission("advancedgroups.release_group", AdvancedGroupCommands.CONFIG.releaseGroupPermissionType.get());
        this.PERMISSIONS = List.of(PUSH_GROUP_PERMISSION, RELEASE_GROUP_PERMISSION);
    }

    public boolean hasPermission(class_2168 commandSourceStack, String permission) {
        for (Permission p : this.PERMISSIONS) {
            if (!p.permission.equals(permission)) continue;
            if (commandSourceStack.method_43737()) {
                return p.hasPermission(commandSourceStack.method_44023());
            }
            if (p.getType().equals((Object)PermissionType.OPS)) {
                return commandSourceStack.method_9259(2);
            }
            return p.hasPermission(null);
        }
        return false;
    }

    private static boolean isFabricPermissionsAPILoaded() {
        if (loaded == null && (loaded = Boolean.valueOf(FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0"))).booleanValue()) {
            AdvancedGroupCommands.LOGGER.info("Fabric permissions API loaded");
        }
        return loaded;
    }

    private record Permission(String permission, PermissionType type) {
        public boolean hasPermission(@Nullable class_3222 player) {
            if (AdvancedGroupPermissionManager.isFabricPermissionsAPILoaded()) {
                return this.checkFabricPermission(player);
            }
            return this.type.hasPermission(player);
        }

        private boolean checkFabricPermission(@Nullable class_3222 player) {
            if (player == null) {
                return false;
            }
            TriState permissionValue = Permissions.getPermissionValue((class_1297)player, (String)this.permission);
            return switch (permissionValue) {
                case TriState.DEFAULT -> this.type.hasPermission(player);
                case TriState.TRUE -> true;
                default -> false;
            };
        }

        public PermissionType getType() {
            return this.type;
        }
    }

    public static enum PermissionType {
        EVERYONE,
        NOONE,
        OPS;


        boolean hasPermission(@Nullable class_3222 player) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case 2 -> player != null && player.method_64475(player.field_13995.method_3798());
            };
        }
    }
}

