/*
 * Decompiled with CFR 0.152.
 */
package dev.alphacerium.advancedgroups.command;

import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.enhancedgroups.config.PersistentGroup;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import dev.alphacerium.advancedgroups.AdvancedGroupCommands;
import dev.alphacerium.advancedgroups.AdvancedGroupCommandsVoicechatPlugin;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@RequiresPermission(value="advancedgroups.push_group")
@Command(value={"advancedgroups"})
public class PushGroupCommands {
    public static final String PUSH_GROUP_COMMAND = "advancedgroups";

    @Command(value={"push"})
    public int push(CommandContext<class_2168> context, @Name(value="player") class_3222 player, @Name(value="group_name") String groupName) {
        PersistentGroup persistentGroup = AdvancedGroupCommands.PERSISTENT_GROUP_STORE.getGroup(groupName);
        if (persistentGroup == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        return this.pushGroup(context, player, persistentGroup.getId());
    }

    @Command(value={"push"})
    public int push(CommandContext<class_2168> context, @Name(value="player") class_3222 player, @Name(value="id") UUID groupID) {
        return this.pushGroup(context, player, groupID);
    }

    public int pushGroup(CommandContext<class_2168> context, class_3222 player, UUID groupId) {
        if (AdvancedGroupCommandsVoicechatPlugin.SERVER_API == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Voice chat not connected"));
            return 0;
        }
        PersistentGroup persistentGroup = AdvancedGroupCommands.PERSISTENT_GROUP_STORE.getGroup(groupId);
        if (persistentGroup == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        VoicechatConnection playerConnection = AdvancedGroupCommandsVoicechatPlugin.SERVER_API.getConnectionOf(player.method_5667());
        if (playerConnection == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Player is not connected to voice chat"));
            return 0;
        }
        UUID voicechatID = AdvancedGroupCommands.PERSISTENT_GROUP_STORE.getVoicechatId(persistentGroup.getId());
        Group group = AdvancedGroupCommandsVoicechatPlugin.SERVER_API.getGroup(voicechatID);
        if (group == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Group not found or not persistent"));
            return 0;
        }
        playerConnection.setGroup(group);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player successfully joined %s group".formatted(group.getName())), false);
        return 1;
    }
}

