/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.vibrantjourneys.blocks;

import de.lucalabs.vibrantjourneys.registry.PVJBlocks;
import de.lucalabs.vibrantjourneys.util.WorldUtils;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5546;
import net.minecraft.class_5556;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends class_2248
implements class_5688 {
    public static final class_2753 TIP_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 TIP_SHAPE_UP = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_265 REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public IcicleBlock(class_4970.class_2251 props) {
        super(props.method_50012(class_3619.field_15971));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065));
    }

    @Nullable
    private static class_2338 findFillableCauldronBelowStalactiteTip(class_1937 level, class_2338 pos) {
        if (pos == null) {
            return null;
        }
        Predicate<class_2680> predicate = state -> state.method_26204() == class_2246.field_10593 || state.method_26204() == class_2246.field_27097;
        BiPredicate<class_2338, class_2680> bipredicate = (blockpos, state) -> IcicleBlock.canDripThrough((class_1922)level, blockpos, state);
        return IcicleBlock.findBlockVertical((class_1936)level, pos, class_2350.field_11033.method_10171(), bipredicate, predicate).orElse(null);
    }

    private static void spawnFallingStalactite(class_2680 state, class_3218 level, class_2338 pos) {
        class_2338.class_2339 posM = pos.method_25503();
        class_2680 blockstate = state;
        while (IcicleBlock.isStalactite(blockstate)) {
            class_1540 fallingblockentity = class_1540.method_40005((class_1937)level, (class_2338)posM, (class_2680)blockstate);
            if (IcicleBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.method_10264() - posM.method_10264(), 6);
                float f = i;
                fallingblockentity.method_6965(f, 40);
                break;
            }
            posM.method_10098(class_2350.field_11033);
            blockstate = level.method_8320((class_2338)posM);
        }
    }

    private static void spawnDripParticle(class_1937 level, class_2338 pos, class_2680 state) {
        class_243 vec3 = state.method_26226((class_1922)level, pos);
        double d1 = (double)pos.method_10263() + 0.5 + vec3.field_1352;
        double d2 = (double)((float)(pos.method_10264() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.method_10260() + 0.5 + vec3.field_1350;
        class_2400 particles = class_2398.field_28078;
        level.method_8406((class_2394)particles, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static class_2338 findTip(class_2680 state, class_1936 level, class_2338 pos) {
        if (IcicleBlock.isTip(state, false)) {
            return pos;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        BiPredicate<class_2338, class_2680> bipredicate = (p_202023_, p_202024_) -> p_202024_.method_27852(PVJBlocks.ICICLE) && p_202024_.method_11654((class_2769)TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical(level, pos, direction.method_10171(), bipredicate, p_154168_ -> IcicleBlock.isTip(p_154168_, false)).orElse(null);
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 level, class_2338 pos, class_2350 dir) {
        class_2350 direction;
        if (IcicleBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!IcicleBlock.isValidPointedDripstonePlacement(level, pos, dir.method_10153())) {
                return null;
            }
            direction = dir.method_10153();
        }
        return direction;
    }

    private static class_5691 calculateDripstoneThickness(class_4538 level, class_2338 pos, class_2350 dir, boolean p_154096_) {
        class_2350 direction = dir.method_10153();
        class_2680 blockstate = level.method_8320(pos.method_10093(dir));
        if (IcicleBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !p_154096_ && blockstate.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!IcicleBlock.isPointedDripstoneWithDirection(blockstate, dir)) {
            return class_5691.field_28065;
        }
        class_5691 dripstonethickness = (class_5691)blockstate.method_11654(THICKNESS);
        if (dripstonethickness != class_5691.field_28065 && dripstonethickness != class_5691.field_28064) {
            class_2680 blockstate1 = level.method_8320(pos.method_10093(direction));
            return !IcicleBlock.isPointedDripstoneWithDirection(blockstate1, dir) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    public static boolean canDrip(class_2680 state) {
        return IcicleBlock.isStalactite(state) && state.method_11654(THICKNESS) == class_5691.field_28065;
    }

    private static boolean isValidPointedDripstonePlacement(class_4538 level, class_2338 pos, class_2350 dir) {
        class_2338 blockpos = pos.method_10093(dir.method_10153());
        class_2680 blockstate = level.method_8320(blockpos);
        return blockstate.method_26206((class_1922)level, blockpos, dir) || IcicleBlock.isPointedDripstoneWithDirection(blockstate, dir);
    }

    private static boolean isTip(class_2680 state, boolean p_154155_) {
        if (!state.method_27852(PVJBlocks.ICICLE)) {
            return false;
        }
        class_5691 dripstonethickness = (class_5691)state.method_11654(THICKNESS);
        return dripstonethickness == class_5691.field_28065 || p_154155_ && dripstonethickness == class_5691.field_28064;
    }

    private static boolean isStalactite(class_2680 state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, class_2350.field_11033);
    }

    private static boolean isStalagmite(class_2680 state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, class_2350.field_11036);
    }

    private static boolean isStalactiteStartPos(class_2680 state, class_4538 level, class_2338 pos) {
        return IcicleBlock.isStalactite(state) && !level.method_8320(pos.method_10084()).method_27852(PVJBlocks.ICICLE);
    }

    private static boolean isPointedDripstoneWithDirection(class_2680 state, class_2350 dir) {
        return state.method_27852(PVJBlocks.ICICLE) && state.method_11654((class_2769)TIP_DIRECTION) == dir;
    }

    @Nullable
    public static class_2338 findStalactiteTipAboveCauldron(class_1937 level, class_2338 pos) {
        BiPredicate<class_2338, class_2680> bipredicate = (p_202030_, p_202031_) -> IcicleBlock.canDripThrough((class_1922)level, p_202030_, p_202031_);
        return IcicleBlock.findBlockVertical((class_1936)level, pos, class_2350.field_11036.method_10171(), bipredicate, IcicleBlock::canDrip).orElse(null);
    }

    private static Optional<class_2338> findBlockVertical(class_1936 level, class_2338 pos, class_2350.class_2352 dir, BiPredicate<class_2338, class_2680> p_202010_, Predicate<class_2680> p_202011_) {
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)dir, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 posM = pos.method_25503();
        for (int i = 1; i < 11; ++i) {
            posM.method_10098(direction);
            class_2680 blockstate = level.method_8320((class_2338)posM);
            if (p_202011_.test(blockstate)) {
                return Optional.of(posM.method_10062());
            }
            if (!level.method_31601(posM.method_10264()) && p_202010_.test((class_2338)posM, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(class_1922 level, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26216(level, pos)) {
            return false;
        }
        if (!state.method_26227().method_15769()) {
            return false;
        }
        class_265 voxelshape = state.method_26220(level, pos);
        return !class_259.method_1074((class_265)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (class_265)voxelshape, (class_247)class_247.field_16896);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TIP_DIRECTION, THICKNESS});
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return IcicleBlock.isValidPointedDripstonePlacement(level, pos, (class_2350)state.method_11654((class_2769)TIP_DIRECTION));
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 state2, class_1936 level, class_2338 pos, class_2338 pos2) {
        if (dir != class_2350.field_11036 && dir != class_2350.field_11033) {
            return state;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        if (direction == class_2350.field_11033 && level.method_8397().method_8674(pos, (Object)this)) {
            return state;
        }
        if (dir == direction.method_10153() && !this.method_9558(state, (class_4538)level, pos)) {
            if (direction == class_2350.field_11033) {
                level.method_39279(pos, (class_2248)this, 2);
            } else {
                level.method_39279(pos, (class_2248)this, 1);
            }
            return state;
        }
        boolean flag = state.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 dripstonethickness = IcicleBlock.calculateDripstoneThickness((class_4538)level, pos, direction, flag);
        return (class_2680)state.method_11657(THICKNESS, (Comparable)dripstonethickness);
    }

    public void method_19286(class_1937 level, class_2680 pos, class_3965 result, class_1676 projectile) {
        class_2338 blockpos = result.method_17777();
        if (!level.field_9236 && projectile.method_36971(level, blockpos) && projectile instanceof class_1685 && projectile.method_18798().method_1033() > 0.6) {
            level.method_8650(blockpos, true);
        }
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float height) {
        if (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
            entity.method_5747(height + 2.0f, 2.0f, level.method_48963().method_48837());
        } else {
            super.method_9554(level, state, pos, entity, height);
        }
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if ((level.method_8314(class_1944.field_9282, pos) > 11 - state.method_26193((class_1922)level, pos) || ((class_1959)level.method_23753(pos).comp_349()).method_39927(pos)) && IcicleBlock.canDrip(state)) {
            IcicleBlock.spawnDripParticle(level, pos, state);
        }
    }

    public void method_9588(class_2680 p_154107_, class_3218 p_154108_, class_2338 p_154109_, class_5819 p_154110_) {
        if (IcicleBlock.isStalagmite(p_154107_) && !this.method_9558(p_154107_, (class_4538)p_154108_, p_154109_)) {
            p_154108_.method_8650(p_154109_, true);
        } else {
            IcicleBlock.spawnFallingStalactite(p_154107_, p_154108_, p_154109_);
        }
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (level.method_8314(class_1944.field_9282, pos) > 11 - state.method_26193((class_1922)level, pos) || ((class_1959)level.method_23753(pos).comp_349()).method_39927(pos)) {
            level.method_8650(pos, true);
            for (int i = 0; i < 10; ++i) {
                IcicleBlock.spawnDripParticle((class_1937)level, pos, state);
            }
            class_2338 blockpos = IcicleBlock.findTip(state, (class_1936)level, pos);
            class_2338 cauldronPos = IcicleBlock.findFillableCauldronBelowStalactiteTip((class_1937)level, blockpos);
            if (cauldronPos != null) {
                class_2680 cauldron = level.method_8320(cauldronPos);
                if (cauldron.method_26204() instanceof class_5546) {
                    WorldUtils.setBlockState((class_1936)level, cauldronPos, class_2246.field_27097.method_9564());
                } else if (cauldron.method_26204() == class_2246.field_27097 && !((class_5556)cauldron.method_26204()).method_32766(cauldron)) {
                    WorldUtils.setBlockState((class_1936)level, cauldronPos, (class_2680)cauldron.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf((Integer)cauldron.method_11654((class_2769)class_5556.field_27206) + 1)));
                }
            }
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction;
        class_2338 blockpos;
        class_1937 levelaccessor = context.method_8045();
        class_2350 direction1 = IcicleBlock.calculateTipDirection((class_4538)levelaccessor, blockpos = context.method_8037(), direction = context.method_32760().method_10153());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.method_8046();
        class_5691 dripstonethickness = IcicleBlock.calculateDripstoneThickness((class_4538)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (class_2680)((class_2680)this.method_9564().method_11657((class_2769)TIP_DIRECTION, (Comparable)direction1)).method_11657(THICKNESS, (Comparable)dripstonethickness);
    }

    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        return class_259.method_1073();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_5691 dripstonethickness = (class_5691)state.method_11654(THICKNESS);
        class_265 voxelshape = dripstonethickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (dripstonethickness == class_5691.field_28065 ? (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11033 ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == class_5691.field_28066 ? FRUSTUM_SHAPE : (dripstonethickness == class_5691.field_28067 ? MIDDLE_SHAPE : BASE_SHAPE)));
        class_243 vec3 = state.method_26226(level, pos);
        return voxelshape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public float method_32913() {
        return 0.125f;
    }

    public void method_10129(class_1937 world, class_2338 pos, class_1540 entity) {
        if (!entity.method_5701()) {
            world.method_20290(1045, pos, 0);
        }
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }
}

