/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.vibrantjourneys.registry;

import de.lucalabs.vibrantjourneys.ProjectVibrantJourneys;
import de.lucalabs.vibrantjourneys.config.PVJConfig;
import de.lucalabs.vibrantjourneys.registry.PVJPlacements;
import de.lucalabs.vibrantjourneys.tags.CompatTags;
import de.lucalabs.vibrantjourneys.tags.FabricTags;
import de.lucalabs.vibrantjourneys.tags.ForgeCompatTags;
import de.lucalabs.vibrantjourneys.tags.PVJTags;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6908;

public final class PVJBiomeModifiers {
    private PVJBiomeModifiers() {
    }

    public static void initialize() {
        ProjectVibrantJourneys.LOGGER.info("initializing biome modifiers");
        PVJBiomeModifiers.initBiomeModifiers();
        PVJBiomeModifiers.initSpawnModifiers();
    }

    private static void initBiomeModifiers() {
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.TWIGS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.DESERT, BiomeType.OCEAN, BiomeType.BEACH, BiomeType.BADLANDS, BiomeType.VERY_COLD)).and(PVJBiomeModifiers.blacklist(class_1972.field_9419)), () -> PVJConfig.enableTwigs);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.FALLEN_LEAVES, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.DESERT, BiomeType.OCEAN, BiomeType.BEACH, BiomeType.MUSHROOM, BiomeType.BADLANDS, BiomeType.VERY_COLD)).and(PVJBiomeModifiers.blacklist(class_1972.field_9419)), () -> PVJConfig.enableFallenLeaves);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.DEAD_FALLEN_LEAVES, PVJBiomeModifiers.biomes(class_1972.field_35110), () -> PVJConfig.enableFallenLeaves);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.DENSE_DEAD_FALLEN_LEAVES, PVJBiomeModifiers.biomes(class_1972.field_35119, class_1972.field_35113), () -> PVJConfig.enableFallenLeaves);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.PINECONES, PVJBiomeModifiers.biomes(BiomeType.CONIFEROUS), () -> PVJConfig.enablePinecones);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SEASHELLS, PVJBiomeModifiers.biomes(BiomeType.OCEAN, BiomeType.BEACH), () -> PVJConfig.enableSeashells);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.OCEAN_FLOOR_SEASHELLS, PVJBiomeModifiers.biomes(BiomeType.OCEAN, BiomeType.BEACH), () -> PVJConfig.enableSeashells);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.ROCKS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.MUSHROOM, BiomeType.VERY_COLD)), () -> PVJConfig.enableRocks);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.BONES, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.MUSHROOM, BiomeType.VERY_COLD)), () -> PVJConfig.enableBones);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CAVE_ROCKS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.MUSHROOM, BiomeType.VERY_COLD)), () -> PVJConfig.enableRocks);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CAVE_BONES, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.MUSHROOM, BiomeType.VERY_COLD)), () -> PVJConfig.enableBones);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.ICE_CHUNKS, PVJBiomeModifiers.biomes(BiomeType.SNOWY).and(PVJBiomeModifiers.blacklist(class_1972.field_9478)), () -> PVJConfig.enableIceChunks);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MOSS_CARPET, PVJBiomeModifiers.biomes(class_1972.field_35119, class_1972.field_35113), () -> PVJConfig.enableMossCarpets);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.BARK_MUSHROOM, PVJBiomeModifiers.overworld(), () -> PVJConfig.enableBarkMushrooms);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SEA_OATS, PVJBiomeModifiers.biomes(BiomeType.BEACH).and(PVJBiomeModifiers.blacklist(BiomeType.VERY_COLD)), () -> PVJConfig.enableSeaOats);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.BEACH_GRASS, PVJBiomeModifiers.biomes(BiomeType.BEACH).and(PVJBiomeModifiers.blacklist(BiomeType.VERY_COLD)), () -> PVJConfig.enableBeachGrass);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CATTAILS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.OCEAN, BiomeType.BEACH, BiomeType.VERY_COLD)).and(PVJBiomeModifiers.blacklist(class_1972.field_9419)), () -> PVJConfig.enableCattails);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SHORT_GRASS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.MUSHROOM)).and(PVJBiomeModifiers.blacklist(class_1972.field_35117)), () -> PVJConfig.enableShortGrass);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.NATURAL_COBWEB, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.MUSHROOM)).and(PVJBiomeModifiers.blacklist(class_1972.field_35117)), () -> PVJConfig.enableNaturalCobwebs);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SMALL_CACTUS, PVJBiomeModifiers.biomes(BiomeType.DESERT), () -> true);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.EXTRA_SEAGRASS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.OCEAN, BiomeType.BEACH, BiomeType.DESERT, BiomeType.BADLANDS)).and(PVJBiomeModifiers.blacklist(class_1972.field_9419)), () -> PVJConfig.enableExtraSeagrass);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.EXTRA_LILYPADS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.OCEAN, BiomeType.BEACH, BiomeType.DESERT, BiomeType.BADLANDS, BiomeType.VERY_COLD)).and(PVJBiomeModifiers.blacklist(class_1972.field_9419)), () -> PVJConfig.enableExtraLilypads);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.EXTRA_GRASS, PVJBiomeModifiers.biomes(BiomeType.RIVER), () -> PVJConfig.enableExtraRiverGrass);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.TIDE_POOL, PVJBiomeModifiers.biomes(class_1972.field_9419), () -> PVJConfig.enableTidePools);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CAVE_ROOTS, PVJBiomeModifiers.overworld(), () -> PVJConfig.enableCaveRoots);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.REEDS, PVJBiomeModifiers.biomes(BiomeType.PLAINS).and(PVJBiomeModifiers.blacklist(class_1972.field_35117)), () -> PVJConfig.enableReeds);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.PRICKLY_BUSH, PVJBiomeModifiers.biomes(class_1972.field_35110), () -> PVJConfig.enablePricklyBush);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.ICICLE, PVJBiomeModifiers.biomes(BiomeType.SNOWY), () -> PVJConfig.enableIcicles);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SANDY_SPROUTS, PVJBiomeModifiers.biomes(BiomeType.BEACH).and(PVJBiomeModifiers.blacklist(BiomeType.VERY_COLD)), () -> PVJConfig.enableSandySprouts);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.WATERGRASS, PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.blacklist(BiomeType.OCEAN, BiomeType.BEACH, BiomeType.BADLANDS, BiomeType.VERY_COLD)).and(PVJBiomeModifiers.blacklist(class_1972.field_9419)), () -> PVJConfig.enableWatergrass);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.GRAVEL_PIT, PVJBiomeModifiers.biomes(class_1972.field_35112, class_1972.field_9412), class_2893.class_2895.field_25186, () -> PVJConfig.enableGravelPits);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.GOLD_PIT, PVJBiomeModifiers.biomes(BiomeType.BADLANDS), class_2893.class_2895.field_25186, () -> PVJConfig.enableGoldPits);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.BEACHED_KELP, PVJBiomeModifiers.biomes(class_1972.field_9434), () -> PVJConfig.enableBeachedKelp);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.DRIED_BEACHED_KELP, PVJBiomeModifiers.biomes(class_1972.field_9434), () -> PVJConfig.enableDriedBeachedKelp);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.GLOWING_BLUE_FUNGUS, PVJBiomeModifiers.biomes(class_1972.field_37543), () -> PVJConfig.enableGlowingBlueFungus);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MUDDY_BONES, PVJBiomeModifiers.biomes(class_1972.field_38748), () -> PVJConfig.enableMuddyBones);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.LOTUS_POND, PVJBiomeModifiers.biomes(class_1972.field_42720), class_2893.class_2895.field_25186, () -> PVJConfig.enableLotusPonds);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.FLOATING_PINK_LOTUS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableFloatingPinkLotus);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.HOT_SPRINGS, c -> c.hasTag(class_6908.field_36515), () -> PVJConfig.enableHotSprings);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.OAK_BUSH, PVJBiomeModifiers.biomes(BiomeType.PLAINS), () -> true);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.YELLOW_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_34470), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.ORANGE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_34470), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.BLUE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_34470), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.PURPLE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_34470), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.WHITE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_34470), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MIXED_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_34470), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANY_YELLOW_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANY_ORANGE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANY_BLUE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANY_PURPLE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANY_WHITE_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANY_MIXED_WILDFLOWERS, PVJBiomeModifiers.biomes(class_1972.field_9414), () -> PVJConfig.enableWildflowers);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SLIME_NODULE, PVJBiomeModifiers.biomes(BiomeType.SWAMP), () -> PVJConfig.enableSlimeNodules);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.PINK_VINES, PVJBiomeModifiers.biomes(class_1972.field_42720), () -> PVJConfig.enablePinkVines);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.OAK_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_OAK_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.BIRCH_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_BIRCH_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.SPRUCE_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_SPRUCE_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.JUNGLE_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_JUNGLE_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.ACACIA_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_ACACIA_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.DARK_OAK_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_DARK_OAK_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CHERRY_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_CHERRY_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.MANGROVE_FALLEN_TREE, c -> c.hasTag(PVJTags.HAS_MANGROVE_LOGS), () -> PVJConfig.enableFallenTrees);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CHARRED_BONES, PVJBiomeModifiers.nether(), () -> PVJConfig.enableCharredBones);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.GLOWCAP, PVJBiomeModifiers.nether(), () -> PVJConfig.enableGlowcap);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CINDERCANE, PVJBiomeModifiers.nether(), () -> PVJConfig.enableCindercane);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.WARPED_NETTLE, PVJBiomeModifiers.biomes(class_1972.field_22075), () -> PVJConfig.enableNetherNettles);
        PVJBiomeModifiers.addBiomeModifier(PVJPlacements.CRIMSON_NETTLE, PVJBiomeModifiers.biomes(class_1972.field_22077), () -> PVJConfig.enableNetherNettles);
    }

    private static void initSpawnModifiers() {
        PVJBiomeModifiers.addSpawnModifier("tropical_fish_in_jungles", PVJBiomeModifiers.overworld().and(PVJBiomeModifiers.biomes(BiomeType.JUNGLE)), class_1311.field_24460, class_1299.field_6111, 25, 5, 5, () -> PVJConfig.enableJungleTropicalFish);
    }

    private static void addBiomeModifier(class_5321<class_6796> feature, Predicate<BiomeSelectionContext> condition, Supplier<Boolean> configCondition) {
        PVJBiomeModifiers.addBiomeModifier(feature, condition, class_2893.class_2895.field_13178, configCondition);
    }

    private static void addBiomeModifier(class_5321<class_6796> feature, Predicate<BiomeSelectionContext> condition, class_2893.class_2895 featureType, Supplier<Boolean> configCondition) {
        if (configCondition.get().booleanValue()) {
            BiomeModifications.addFeature(condition, (class_2893.class_2895)featureType, feature);
        }
    }

    private static void addSpawnModifier(String spawnName, Predicate<BiomeSelectionContext> condition, class_1311 group, class_1299<?> entityType, int weight, int minGroupSize, int maxGroupSize, Supplier<Boolean> configCondition) {
        if (configCondition.get().booleanValue()) {
            BiomeModifications.addSpawn(condition, (class_1311)group, entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize);
        }
    }

    private static List<class_5321<class_1959>> veryCold() {
        return List.of(class_1972.field_9463, class_1972.field_35117, class_1972.field_9478, class_1972.field_34472, class_1972.field_9453, class_1972.field_9435, class_1972.field_9418, class_1972.field_34474);
    }

    private static Predicate<BiomeSelectionContext> overworld() {
        return c -> c.hasTag(class_6908.field_37393);
    }

    private static Predicate<BiomeSelectionContext> nether() {
        return c -> c.hasTag(class_6908.field_36518);
    }

    @SafeVarargs
    private static Predicate<BiomeSelectionContext> biomes(class_5321<class_1959> ... biomes) {
        Predicate<BiomeSelectionContext> pred = c -> false;
        for (class_5321<class_1959> biome : biomes) {
            pred = pred.or(c -> c.getBiomeKey().equals(biome));
        }
        return pred;
    }

    private static Predicate<BiomeSelectionContext> biomes(BiomeType ... biomes) {
        Predicate<BiomeSelectionContext> pred = c -> false;
        for (BiomeType t : biomes) {
            pred = pred.or(PVJBiomeModifiers.fromBiomeType(t));
        }
        return pred;
    }

    @SafeVarargs
    private static Predicate<BiomeSelectionContext> blacklist(class_5321<class_1959> ... biomes) {
        Predicate<BiomeSelectionContext> pred = c -> true;
        for (class_5321<class_1959> biome : biomes) {
            pred = pred.and(c -> !c.getBiomeKey().equals(biome));
        }
        return pred;
    }

    private static Predicate<BiomeSelectionContext> blacklist(BiomeType ... biomes) {
        Predicate<BiomeSelectionContext> pred = c -> true;
        for (BiomeType t : biomes) {
            pred = pred.and(PVJBiomeModifiers.fromBiomeType(t).negate());
        }
        return pred;
    }

    private static Predicate<BiomeSelectionContext> fromBiomeType(BiomeType t) {
        return switch (t) {
            default -> throw new IncompatibleClassChangeError();
            case BiomeType.FOREST -> c -> c.hasTag(class_6908.field_36517);
            case BiomeType.PLAINS -> c -> c.hasTag(FabricTags.IS_PLAINS) || c.hasTag(FabricTags.PLAINS);
            case BiomeType.OCEAN -> c -> c.hasTag(class_6908.field_36509);
            case BiomeType.BEACH -> c -> c.hasTag(class_6908.field_36510);
            case BiomeType.BADLANDS -> c -> c.hasTag(class_6908.field_36513);
            case BiomeType.RIVER -> c -> c.hasTag(class_6908.field_36511);
            case BiomeType.CONIFEROUS -> c -> c.hasTag(ForgeCompatTags.IS_CONIFEROUS) || c.hasTag(CompatTags.IS_CONIFEROUS);
            case BiomeType.SNOWY -> c -> c.hasTag(ForgeCompatTags.IS_SNOWY) || c.hasTag(FabricTags.IS_SNOWY) || c.hasTag(FabricTags.SNOWY);
            case BiomeType.MUSHROOM -> c -> c.hasTag(FabricTags.IS_MUSHROOM) || c.hasTag(FabricTags.MUSHROOM);
            case BiomeType.DESERT -> c -> c.hasTag(FabricTags.IS_DESERT) || c.hasTag(FabricTags.DESERT);
            case BiomeType.SWAMP -> c -> c.hasTag(FabricTags.IS_SWAMP) || c.hasTag(FabricTags.SWAMP);
            case BiomeType.TAIGA -> c -> c.hasTag(class_6908.field_36515);
            case BiomeType.JUNGLE -> c -> c.hasTag(class_6908.field_36516);
            case BiomeType.VERY_COLD -> c -> PVJBiomeModifiers.veryCold().contains(c.getBiomeKey());
        };
    }

    private static enum BiomeType {
        FOREST,
        PLAINS,
        OCEAN,
        DESERT,
        BEACH,
        BADLANDS,
        RIVER,
        CONIFEROUS,
        SNOWY,
        MUSHROOM,
        SWAMP,
        TAIGA,
        JUNGLE,
        VERY_COLD;

    }
}

