/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.vibrantjourneys.world.features;

import com.mojang.serialization.Codec;
import de.lucalabs.vibrantjourneys.blocks.BarkMushroomBlock;
import de.lucalabs.vibrantjourneys.blocks.FallenLeavesBlock;
import de.lucalabs.vibrantjourneys.blocks.GroundcoverBlock;
import de.lucalabs.vibrantjourneys.blocks.HollowLogBlock;
import de.lucalabs.vibrantjourneys.config.PVJConfig;
import de.lucalabs.vibrantjourneys.util.PVJFeatureVars;
import de.lucalabs.vibrantjourneys.util.TreeFeatureUtils;
import de.lucalabs.vibrantjourneys.util.WorldUtils;
import de.lucalabs.vibrantjourneys.world.features.configurations.FallenTreeConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FallenTreeFeature
extends class_3031<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<FallenTreeConfiguration> context) {
        HashSet<TreeFeatureUtils.ChanceBiomeEntry> biomeEntries;
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 rand = context.method_33654();
        class_2680 hollowLog = ((FallenTreeConfiguration)context.method_33656()).hollowLog();
        class_2680 baseLog = ((FallenTreeConfiguration)context.method_33656()).baseLog();
        String biome = ((class_5321)level.method_23753(pos).method_40230().get()).method_29177().toString();
        int chance = TreeFeatureUtils.getChance(biome, biomeEntries = this.getEntrySet(baseLog.method_26204()));
        if (chance == -1) {
            chance = 10;
        }
        if (rand.method_43057() > (float)chance / 100.0f) {
            return false;
        }
        class_2680 down = level.method_8320(pos.method_10074());
        if (down.method_26164(class_3481.field_15467) || down.method_26204() == class_2246.field_10491 || down.method_26227().method_15771()) {
            return false;
        }
        int length = rand.method_43048(3) + 4;
        class_2350 dir = class_2350.class_2353.field_11062.method_10183(rand);
        class_2350 dirCounterClockwise = dir.method_10160();
        class_2350 dirClockwise = dir.method_10170();
        boolean branched = false;
        for (int i = 0; i < length; ++i) {
            if (!this.canReplace(level, pos) || this.canReplace(level, pos.method_10074())) {
                return false;
            }
            pos = pos.method_10093(dir);
        }
        pos = context.method_33655();
        List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders = ((FallenTreeConfiguration)context.method_33656()).vegetationProviders();
        class_5819 randomSource = level.method_8409();
        for (int i = 0; i < length; ++i) {
            if (this.canReplace(level, pos)) {
                if (!down.method_45474() && !down.method_26227().method_39360((class_3611)class_3612.field_15910) || i > length / 2) {
                    BarkMushroomBlock mushroom;
                    class_2680 state;
                    boolean mossy = ((FallenTreeConfiguration)context.method_33656()).canBeMossy() && randomSource.method_43056();
                    WorldUtils.setBlockState((class_1936)level, pos, (class_2680)((class_2680)hollowLog.method_11657((class_2769)class_2465.field_11459, (Comparable)dir.method_10166())).method_11657((class_2769)HollowLogBlock.MOSSY, (Comparable)Boolean.valueOf(mossy)), 2);
                    if (level.method_22347(pos.method_10084()) && rand.method_43057() < 0.75f) {
                        WorldUtils.setBlockState((class_1936)level, pos.method_10084(), this.getVegetationToPlace(vegetationProviders, randomSource, pos.method_10084()), 2);
                    }
                    if (!branched && i <= length / 2 + 1 && rand.method_43057() < 0.5f) {
                        class_2338 branchPos = rand.method_43056() ? pos.method_10093(dirCounterClockwise) : pos.method_10093(dirClockwise);
                        WorldUtils.setBlockState((class_1936)level, branchPos, (class_2680)baseLog.method_11657((class_2769)class_2465.field_11459, (Comparable)dirCounterClockwise.method_10166()), 2);
                        if (level.method_22347(branchPos.method_10084()) && rand.method_43057() < 0.4f) {
                            WorldUtils.setBlockState((class_1936)level, branchPos.method_10084(), this.getVegetationToPlace(vegetationProviders, randomSource, branchPos.method_10084()), 2);
                        }
                        branched = true;
                    }
                    class_2338 original = pos;
                    if (this.canReplace(level, pos = pos.method_10093(dirCounterClockwise))) {
                        if (rand.method_43057() < 0.4f && class_2248.method_9501((class_265)level.method_8320(pos.method_10074()).method_26220((class_1922)level, pos.method_10074()), (class_2350)class_2350.field_11036)) {
                            state = this.getVegetationToPlace(vegetationProviders, randomSource, pos);
                            if (state.method_26184((class_4538)level, pos)) {
                                WorldUtils.setBlockState((class_1936)level, pos, state, 2);
                            }
                        } else if (rand.method_43057() < 0.4f && PVJConfig.enableBarkMushrooms) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            WorldUtils.setBlockState((class_1936)level, pos, (class_2680)mushroom.method_9564().method_11657((class_2769)BarkMushroomBlock.FACING, (Comparable)dirCounterClockwise), 2);
                        }
                    }
                    pos = original;
                    if (this.canReplace(level, pos = pos.method_10093(dirClockwise))) {
                        if (rand.method_43057() < 0.4f && class_2248.method_9501((class_265)level.method_8320(pos.method_10074()).method_26220((class_1922)level, pos.method_10074()), (class_2350)class_2350.field_11036)) {
                            state = this.getVegetationToPlace(vegetationProviders, randomSource, pos);
                            if (state.method_26184((class_4538)level, pos)) {
                                WorldUtils.setBlockState((class_1936)level, pos, state, 2);
                            }
                        } else if (rand.method_43057() < 0.4f && PVJConfig.enableBarkMushrooms) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            WorldUtils.setBlockState((class_1936)level, pos, (class_2680)mushroom.method_9564().method_11657((class_2769)BarkMushroomBlock.FACING, (Comparable)dirClockwise), 2);
                        }
                    }
                    pos = original;
                    pos = pos.method_10093(dir);
                } else {
                    dir = dir.method_10153();
                    pos = context.method_33655().method_10093(dir);
                }
            } else {
                return length - i < length;
            }
            down = level.method_8320(pos.method_10074());
        }
        return true;
    }

    public boolean canReplace(class_5281 world, class_2338 pos) {
        return world.method_8320(pos).method_45474() || world.method_22347(pos) || world.method_8320(pos).method_26204() instanceof FallenLeavesBlock || world.method_8320(pos).method_26204() instanceof GroundcoverBlock;
    }

    public HashSet<TreeFeatureUtils.ChanceBiomeEntry> getEntrySet(class_2248 log) {
        if (log == class_2246.field_10431) {
            return PVJFeatureVars.OAK;
        }
        if (log == class_2246.field_10511) {
            return PVJFeatureVars.BIRCH;
        }
        if (log == class_2246.field_10037) {
            return PVJFeatureVars.SPRUCE;
        }
        if (log == class_2246.field_10306) {
            return PVJFeatureVars.JUNGLE;
        }
        if (log == class_2246.field_10533) {
            return PVJFeatureVars.ACACIA;
        }
        if (log == class_2246.field_10010) {
            return PVJFeatureVars.DARK_OAK;
        }
        if (log == class_2246.field_37545) {
            return PVJFeatureVars.MANGROVE;
        }
        if (log == class_2246.field_42729) {
            return PVJFeatureVars.CHERRY;
        }
        return PVJFeatureVars.OAK;
    }

    private class_2680 getVegetationToPlace(List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders, class_5819 randomSource, class_2338 pos) {
        int numProviders = vegetationProviders.size();
        FallenTreeConfiguration.FallenTreeVegetation vegetation = null;
        while (vegetation == null) {
            Optional<String> configOption;
            int random = randomSource.method_43048(numProviders);
            FallenTreeConfiguration.FallenTreeVegetation temp = vegetationProviders.get(random);
            if (temp.configOption().isPresent() && !PVJConfig.configOptions.get((configOption = temp.configOption()).get()).booleanValue()) continue;
            vegetation = temp;
        }
        return vegetation.provider().method_23455(randomSource, pos);
    }
}

