/*
 * Decompiled with CFR 0.152.
 */
package de.lucalabs.vibrantjourneys.world.features;

import com.mojang.serialization.Codec;
import de.lucalabs.vibrantjourneys.util.WorldUtils;
import de.lucalabs.vibrantjourneys.world.features.configurations.MultipleVegetationPatchConfiguration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2222;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_4865;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class MultipleWaterloggedVegetationPatchFeature
extends class_3031<MultipleVegetationPatchConfiguration> {
    public MultipleWaterloggedVegetationPatchFeature(Codec<MultipleVegetationPatchConfiguration> codec) {
        super(codec);
    }

    private static boolean isExposed(class_5281 level, Set<class_2338> set, class_2338 pos, class_2338.class_2339 posMutable) {
        return MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, class_2350.field_11043) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, class_2350.field_11034) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, class_2350.field_11035) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, class_2350.field_11039) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, class_2350.field_11033);
    }

    private static boolean isExposedDirection(class_5281 level, class_2338 pos, class_2338.class_2339 posMutable, class_2350 dir) {
        posMutable.method_25505((class_2382)pos, dir);
        return !level.method_8320((class_2338)posMutable).method_26206((class_1922)level, (class_2338)posMutable, dir.method_10153());
    }

    public boolean method_13151(class_5821<MultipleVegetationPatchConfiguration> context) {
        class_5281 worldgenlevel = context.method_33652();
        MultipleVegetationPatchConfiguration config = (MultipleVegetationPatchConfiguration)context.method_33656();
        class_5819 random = context.method_33654();
        if (random.method_43057() > config.placementChance) {
            return false;
        }
        class_2338 blockpos = context.method_33655();
        Predicate<class_2680> predicate = p_204782_ -> p_204782_.method_26164(config.replaceable);
        int i = config.xzRadius.method_35008(random) + 1;
        int j = config.xzRadius.method_35008(random) + 1;
        Set<class_2338> set = this.placeGroundPatch(worldgenlevel, config, random, blockpos, predicate, i, j);
        this.distributeVegetation(context, worldgenlevel, config, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<class_2338> placeGroundPatch(class_5281 level, MultipleVegetationPatchConfiguration config, class_5819 rand, class_2338 pos, Predicate<class_2680> replace, int x, int z) {
        Set<class_2338> set = this.createGround(level, config, rand, pos, replace, x, z);
        HashSet<class_2338> set1 = new HashSet<class_2338>();
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        for (class_2338 blockpos : set) {
            if (MultipleWaterloggedVegetationPatchFeature.isExposed(level, set, blockpos, blockpos$mutableblockpos)) continue;
            set1.add(blockpos);
        }
        for (class_2338 blockpos1 : set1) {
            WorldUtils.setBlockState((class_1936)level, blockpos1, class_2246.field_10382.method_9564(), 2);
        }
        return set1;
    }

    protected Set<class_2338> createGround(class_5281 level, MultipleVegetationPatchConfiguration config, class_5819 rand, class_2338 pos, Predicate<class_2680> predicate, int x, int z) {
        HashSet<class_2338> set = new HashSet<class_2338>();
        this.carve(set, level, config, rand, pos, predicate, x, z, true);
        this.carve(set, level, config, rand, pos.method_10074(), predicate, x - 1, z - 1, false);
        return set;
    }

    private void carve(Set<class_2338> set, class_5281 level, MultipleVegetationPatchConfiguration config, class_5819 rand, class_2338 pos, Predicate<class_2680> predicate, int x, int z, boolean surface) {
        class_2338.class_2339 blockpos$mutableblockpos = pos.method_25503();
        class_2338.class_2339 blockpos$mutableblockpos1 = blockpos$mutableblockpos.method_25503();
        class_2350 direction = config.surface.method_34379();
        class_2350 direction1 = direction.method_10153();
        for (int i = -x; i <= x; ++i) {
            boolean flag = i == -x || i == x;
            for (int j = -z; j <= z; ++j) {
                boolean flag4;
                boolean flag1 = j == -z || j == z;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.extraEdgeColumnChance == 0.0f || rand.method_43057() > config.extraEdgeColumnChance)) continue;
                blockpos$mutableblockpos.method_25504((class_2382)pos, i, 0, j);
                for (int k = 0; (!surface || level.method_16358((class_2338)blockpos$mutableblockpos, class_4970.class_4971::method_26215)) && k < config.verticalRange; ++k) {
                    blockpos$mutableblockpos.method_10098(direction);
                }
                for (int i1 = 0; level.method_16358((class_2338)blockpos$mutableblockpos, p_204784_ -> !p_204784_.method_26215()) && i1 < config.verticalRange; ++i1) {
                    blockpos$mutableblockpos.method_10098(direction1);
                }
                blockpos$mutableblockpos1.method_25505((class_2382)blockpos$mutableblockpos, config.surface.method_34379());
                class_2680 blockstate = level.method_8320((class_2338)blockpos$mutableblockpos1);
                if (!blockstate.method_26206((class_1922)level, (class_2338)blockpos$mutableblockpos1, config.surface.method_34379().method_10153())) continue;
                int l = config.depth.method_35008(rand) + (config.extraBottomBlockChance > 0.0f && rand.method_43057() < config.extraBottomBlockChance ? 1 : 0);
                class_2338 blockpos = blockpos$mutableblockpos1.method_10062();
                boolean flag5 = this.placeGround(level, config, predicate, rand, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
    }

    protected void distributeVegetation(class_5821<MultipleVegetationPatchConfiguration> context, class_5281 level, MultipleVegetationPatchConfiguration config, class_5819 rand, Set<class_2338> set, int p_160619_, int p_160620_) {
        for (class_2338 blockpos : set) {
            if (config.vegetationChance > 0.0f && rand.method_43057() < config.vegetationChance) {
                this.placeVegetation(level, config, context.method_33653(), rand, blockpos);
                if (rand.method_43048(20) != 0) continue;
                for (int i = 0; i < 32; ++i) {
                    class_2338 pos = blockpos;
                    class_2680 blockstate = class_2246.field_10376.method_9564();
                    for (int j = 0; j < i / 16; ++j) {
                        if (!level.method_8320((pos = pos.method_10069(rand.method_43048(3) - 1, (rand.method_43048(3) - 1) * rand.method_43048(3) / 2, rand.method_43048(3) - 1)).method_10074()).method_26234((class_1922)level, pos.method_10074()) || !blockstate.method_26184((class_4538)level, pos)) continue;
                        class_2680 blockstate1 = level.method_8320(pos);
                        if (blockstate1.method_27852(class_2246.field_10382) && level.method_8316(pos).method_15761() == 8) {
                            WorldUtils.setBlockState((class_1936)level, pos, blockstate, 3);
                            continue;
                        }
                        if (blockstate1.method_27852(class_2246.field_9993) && rand.method_43056()) {
                            int l = Math.min((Integer)blockstate1.method_11654((class_2769)class_4865.field_22509) + 1, 25);
                            if (level.method_8320(pos.method_10084()).method_26227().method_15772() != class_3612.field_15910) continue;
                            WorldUtils.setBlockState((class_1936)level, pos, (class_2680)blockstate1.method_11657((class_2769)class_4865.field_22509, (Comparable)Integer.valueOf(l)), 3);
                            continue;
                        }
                        if (!blockstate1.method_27852(class_2246.field_10376) || rand.method_43048(3) != 0 || level.method_8320(pos.method_10084()).method_26227().method_15772() != class_3612.field_15910) continue;
                        WorldUtils.setBlockState((class_1936)level, pos, class_2246.field_10238.method_9564(), 3);
                    }
                }
                continue;
            }
            if (level.method_8316(blockpos).method_15772() != class_3612.field_15910 || level.method_8320(blockpos).method_26204() != class_2246.field_10382 || !(rand.method_43057() < 0.25f)) continue;
            this.tryPlaceCoral(level, blockpos, rand);
        }
    }

    private void tryPlaceCoral(class_5281 level, class_2338 pos, class_5819 rand) {
        if (level.method_8320(pos.method_10074()).method_26234((class_1922)level, pos.method_10074())) {
            if (rand.method_43056()) {
                Optional<class_2248> coral = this.getRandomCoral(rand);
                coral.ifPresent(block -> WorldUtils.setBlockState((class_1936)level, pos, block.method_9564(), 2));
            }
        } else {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                Optional<class_2248> coral;
                if (!rand.method_43056() || !level.method_8320(pos.method_10093(direction)).method_26234((class_1922)level, pos.method_10093(direction)) || !(coral = this.getRandomCoral(rand)).isPresent()) continue;
                class_2680 blockstate = coral.get().method_9564();
                if (blockstate.method_28498((class_2769)class_2222.field_9933)) {
                    blockstate = (class_2680)blockstate.method_11657((class_2769)class_2222.field_9933, (Comparable)direction.method_10153());
                }
                WorldUtils.setBlockState((class_1936)level, pos, blockstate, 2);
            }
        }
    }

    private Optional<class_2248> getRandomCoral(class_5819 random) {
        class_6885.class_6888 tag = class_7923.field_41175.method_40266(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_3481.field_15476.comp_327())).orElse(null);
        if (tag == null || tag.method_40239().toList().isEmpty()) {
            return Optional.empty();
        }
        return tag.method_40243(random).map(class_6880::comp_349);
    }

    protected void placeVegetation(class_5281 world, MultipleVegetationPatchConfiguration config, class_2794 chunkGenerator, class_5819 rand, class_2338 pos) {
        class_2378 configuredFeatures = world.method_30349().method_30530(class_7924.field_41239);
        for (class_5321<class_2975<?, ?>> feature : config.vegetationFeature) {
            class_2680 blockstate;
            if (!((class_2975)configuredFeatures.method_29107(feature)).method_12862(world, chunkGenerator, rand, pos.method_10074().method_10093(config.surface.method_34379().method_10153())) || !(blockstate = world.method_8320(pos)).method_28498((class_2769)class_2741.field_12508) || ((Boolean)blockstate.method_11654((class_2769)class_2741.field_12508)).booleanValue()) continue;
            WorldUtils.setBlockState((class_1936)world, pos, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.TRUE), 2);
        }
    }

    protected boolean placeGround(class_5281 level, MultipleVegetationPatchConfiguration config, Predicate<class_2680> pred, class_5819 rand, class_2338.class_2339 pos, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            class_2680 blockstate1;
            class_2680 blockstate = config.groundState.method_23455(rand, (class_2338)pos);
            if (blockstate.method_27852((blockstate1 = level.method_8320((class_2338)pos)).method_26204())) continue;
            if (!pred.test(blockstate1)) {
                return i != 0;
            }
            WorldUtils.setBlockState((class_1936)level, (class_2338)pos, blockstate, 2);
            pos.method_10098(config.surface.method_34379());
        }
        return true;
    }
}

