/*
 * Decompiled with CFR 0.152.
 */
package io.github.elias.beemastery.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"beemastery");
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"beemastery");
    public static final RegistryObject<Block> DRACONIC_BLOCK = ModBlocks.register("draconic_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(5.0f, 6.0f).m_60999_()));
    public static final RegistryObject<Block> LEGENDARY_BLOCK = ModBlocks.register("legendary_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(7.0f, 8.0f).m_60999_()));
    public static final RegistryObject<Block> REINFORCED_BLOCK = ModBlocks.register("reinforced_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(4.0f, 5.0f).m_60999_()));
    public static final RegistryObject<Block> MUTATED_IRON_BLOCK = ModBlocks.register("mutated_iron_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 4.0f).m_60999_()));
    public static final RegistryObject<Item> DRACONIC_BLOCK_ITEM = ModBlocks.registerBlockItem("draconic_block", DRACONIC_BLOCK);
    public static final RegistryObject<Item> LEGENDARY_BLOCK_ITEM = ModBlocks.registerBlockItem("legendary_block", LEGENDARY_BLOCK);
    public static final RegistryObject<Item> REINFORCED_BLOCK_ITEM = ModBlocks.registerBlockItem("reinforced_block", REINFORCED_BLOCK);
    public static final RegistryObject<Item> MUTATED_IRON_BLOCK_ITEM = ModBlocks.registerBlockItem("mutated_iron_block", MUTATED_IRON_BLOCK);

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return BLOCK_ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        BLOCK_ITEMS.register(eventBus);
    }
}

