/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simplebalance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_8051;

public class ConfigLoader {
    private static final Map<String, Map<String, Integer>> armorValues = new HashMap<String, Map<String, Integer>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "simplebalance_armor_stats.json";
    private static final Type CONFIG_TYPE = new TypeToken<Map<String, Map<String, Integer>>>(){}.getType();

    public static int getDefense(String materialName, class_8051 type) {
        return armorValues.getOrDefault(materialName.toLowerCase(), Map.of()).getOrDefault(type.method_48400(), -1);
    }

    private static void createDefaultConfig(Path path) throws IOException {
        Map<String, Map<String, Integer>> defaultConfig = Map.of("leather", Map.of("helmet", 1, "chestplate", 2, "leggings", 2, "boots", 1), "chainmail", Map.of("helmet", 1, "chestplate", 3, "leggings", 3, "boots", 1), "gold", Map.of("helmet", 2, "chestplate", 3, "leggings", 3, "boots", 2), "iron", Map.of("helmet", 3, "chestplate", 4, "leggings", 4, "boots", 3), "diamond", Map.of("helmet", 4, "chestplate", 5, "leggings", 5, "boots", 4), "netherite", Map.of("helmet", 4, "chestplate", 6, "leggings", 6, "boots", 4), "turtle", Map.of("helmet", 3));
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(defaultConfig, (Appendable)writer);
        }
    }

    private static Path getJarDirectory() throws URISyntaxException {
        Path path = Paths.get(ConfigLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return path.getParent();
        }
        return Path.of(".", new String[0]).toAbsolutePath();
    }

    static {
        try {
            Path configPath = ConfigLoader.getJarDirectory().resolve(FILE_NAME);
            if (Files.notExists(configPath, new LinkOption[0])) {
                ConfigLoader.createDefaultConfig(configPath);
            }
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                armorValues.putAll((Map)GSON.fromJson((Reader)reader, CONFIG_TYPE));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load armor config: " + String.valueOf(e));
        }
    }
}

