/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simplebalance;

import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;

public class IronmanMode {
    private static final class_2960 IRONMAN_HEALTH_MODIFIER_ID = class_2960.method_60655((String)"simplebalance", (String)"ironman_health_reduction");

    public static void init() {
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            if (!alive) {
                IronmanMode.isPlayerInIronmanTeam(oldPlayer);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!alive && IronmanMode.isPlayerInIronmanTeam(oldPlayer)) {
                IronmanMode.onPlayerRespawnAfterDeath(newPlayer);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (IronmanMode.isPlayerInIronmanTeam(player)) {
                IronmanMode.applyHealthReduction(player);
            }
        });
    }

    public static int enableIronman(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9226(() -> class_2561.method_43470((String)"This command can only be used by players.").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        if (IronmanMode.isPlayerInIronmanTeam(player)) {
            source.method_9226(() -> class_2561.method_43470((String)"You have already enabled Ironman Mode.").method_27692(class_124.field_1054), false);
            return 0;
        }
        IronmanMode.assignPlayerToIronmanTeam(player);
        IronmanMode.applyHealthReduction(player);
        source.method_9226(() -> class_2561.method_43470((String)"Ironman Mode enabled! All items and XP will be lost upon death. Your health has been halved.").method_27692(class_124.field_1054), false);
        String broadcastMessage = String.format("Player %s has enabled Ironman Mode.", player.method_5477().getString());
        Objects.requireNonNull(player.method_5682()).method_3760().method_43514((class_2561)class_2561.method_43470((String)broadcastMessage).method_27692(class_124.field_1054), false);
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        class_3218 world = (class_3218)player.method_37908();
        world.method_8396(null, player.method_24515(), class_3417.field_14865, class_3419.field_15248, 1.0f, 1.0f);
        world.method_65096((class_2394)class_2398.field_50250, x, y, z, 50, 0.4, 1.5, 0.4, 0.05);
        world.method_65096((class_2394)class_2398.field_50247, x, y, z, 40, 0.8, 1.5, 0.8, 0.05);
        world.method_65096((class_2394)class_2398.field_11249, x, y, z, 40, 0.5, 1.5, 0.5, 0.05);
        return 1;
    }

    public static boolean isPlayerInIronmanTeam(class_3222 player) {
        class_2995 scoreboard = Objects.requireNonNull(player.method_5682()).method_3845();
        class_268 ironmanTeam = scoreboard.method_1153("ironman");
        if (ironmanTeam == null) {
            return false;
        }
        return scoreboard.method_1164(player.method_5820()) == ironmanTeam;
    }

    private static void onPlayerRespawnAfterDeath(class_3222 newPlayer) {
        IronmanMode.removePlayerFromIronmanTeam(newPlayer);
        IronmanMode.removeHealthReduction(newPlayer);
        newPlayer.method_7353((class_2561)class_2561.method_43470((String)"Ironman Mode disabled due to death.").method_27692(class_124.field_1054), false);
    }

    private static void createIronmanTeam(class_2995 scoreboard) {
        class_268 ironmanTeam = scoreboard.method_1153("ironman");
        if (ironmanTeam == null) {
            ironmanTeam = scoreboard.method_1171("ironman");
            ironmanTeam.method_1138((class_2561)class_2561.method_43470((String)"\u2620 ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            ironmanTeam.method_1135(false);
            ironmanTeam.method_1143(true);
        }
    }

    public static void assignPlayerToIronmanTeam(class_3222 player) {
        class_2995 scoreboard = Objects.requireNonNull(player.method_5682()).method_3845();
        IronmanMode.createIronmanTeam(scoreboard);
        class_268 ironmanTeam = scoreboard.method_1153("ironman");
        if (ironmanTeam != null) {
            scoreboard.method_1172(player.method_5820(), ironmanTeam);
        }
    }

    public static void removePlayerFromIronmanTeam(class_3222 player) {
        class_2995 scoreboard = Objects.requireNonNull(player.method_5682()).method_3845();
        class_268 ironmanTeam = scoreboard.method_1153("ironman");
        if (ironmanTeam != null) {
            scoreboard.method_1157(player.method_5820(), ironmanTeam);
        }
    }

    private static void applyHealthReduction(class_3222 player) {
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6200(IRONMAN_HEALTH_MODIFIER_ID);
            healthAttribute.method_26837(new class_1322(IRONMAN_HEALTH_MODIFIER_ID, -10.0, class_1322.class_1323.field_6328));
        }
    }

    private static void removeHealthReduction(class_3222 player) {
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6200(IRONMAN_HEALTH_MODIFIER_ID);
        }
    }
}

