/*
 * Decompiled with CFR 0.152.
 */
package com.github.ob_yekt.simplebalance;

import com.github.ob_yekt.simplebalance.ConfigLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_8051;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class LoreManager {
    private static final String LORE_PREFIX = "simplebalance: ";

    public static void applyArmorLore(class_1799 stack) {
        if (!LoreManager.isArmorItem(stack)) {
            return;
        }
        class_8051 equipmentType = LoreManager.getEquipmentType(stack);
        if (equipmentType == null) {
            return;
        }
        String materialId = LoreManager.getMaterialIdFromItem(stack);
        int defense = ConfigLoader.getDefense(materialId, equipmentType);
        if (defense == -1) {
            return;
        }
        LoreManager.removeExistingLore(stack);
        class_5250 loreText = class_2561.method_43470((String)LORE_PREFIX).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)("+" + defense + " Armor")).method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_10978(Boolean.valueOf(false))));
        class_9290 existingLore = (class_9290)stack.method_58694(class_9334.field_49632);
        ArrayList<class_5250> loreLines = new ArrayList<class_5250>();
        if (existingLore != null) {
            loreLines.addAll(existingLore.comp_2400());
        }
        loreLines.add(0, loreText);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
    }

    private static void removeExistingLore(class_1799 stack) {
        class_9290 existingLore = (class_9290)stack.method_58694(class_9334.field_49632);
        if (existingLore == null) {
            return;
        }
        List<class_2561> filteredLines = existingLore.comp_2400().stream().filter(line -> !line.getString().startsWith(LORE_PREFIX)).toList();
        if (filteredLines.isEmpty()) {
            stack.method_57381(class_9334.field_49632);
        } else {
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(filteredLines));
        }
    }

    private static boolean isArmorItem(class_1799 stack) {
        return LoreManager.getEquipmentType(stack) != null;
    }

    private static class_8051 getEquipmentType(class_1799 stack) {
        String itemName = stack.method_7909().toString().toLowerCase();
        if (itemName.contains("helmet")) {
            return class_8051.field_41934;
        }
        if (itemName.contains("chestplate")) {
            return class_8051.field_41935;
        }
        if (itemName.contains("leggings")) {
            return class_8051.field_41936;
        }
        if (itemName.contains("boots")) {
            return class_8051.field_41937;
        }
        return null;
    }

    private static String getMaterialIdFromItem(class_1799 stack) {
        String itemName = stack.method_7909().toString().toLowerCase();
        if (itemName.contains("leather")) {
            return "leather";
        }
        if (itemName.contains("chainmail") || itemName.contains("chain")) {
            return "chainmail";
        }
        if (itemName.contains("golden") || itemName.contains("gold")) {
            return "gold";
        }
        if (itemName.contains("iron")) {
            return "iron";
        }
        if (itemName.contains("diamond")) {
            return "diamond";
        }
        if (itemName.contains("netherite")) {
            return "netherite";
        }
        if (itemName.contains("turtle")) {
            return "turtle";
        }
        return "unknown";
    }
}

