/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.PerfTimer;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.config.ConfigGUI;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.renderdoc.CaptureManager;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.renderdoc.RenderDocLoader;
import com.qendolin.betterclouds.util.ChatUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7485;

public class Commands {
    static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        class_310 client = class_310.method_1551();
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:profile").then(ClientCommandManager.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            ChatUtil.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:profile").then(ClientCommandManager.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            ChatUtil.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        }))).then(ClientCommandManager.literal((String)"stop").executes(context -> {
            PerfTimer timer;
            ChatUtil.debugChatMessage("profiling.disabled", new Object[0]);
            Debug.profileInterval = 0;
            Renderer renderer = BetterClouds.getCloudsRenderer();
            if (renderer != null && (timer = renderer.resources().timer()) != null) {
                timer.reset();
            }
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:frustum").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            client.field_1769.method_35775();
            return 1;
        }))).then(ClientCommandManager.literal((String)"release").executes(context -> {
            client.field_1769.method_35776();
            return 1;
        }))).then(ClientCommandManager.literal((String)"debugCulling").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            Debug.frustumCulling = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:generator").then(ClientCommandManager.literal((String)"pause").executes(context -> {
            Debug.generatorPause = true;
            ChatUtil.debugChatMessage("generatorPaused", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"resume").executes(context -> {
            Debug.generatorPause = false;
            ChatUtil.debugChatMessage("generatorResumed", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"update").executes(context -> {
            Debug.generatorForceUpdate = true;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:animation").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pause").executes(context -> {
            Debug.animationPause = 0;
            ChatUtil.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })).then(ClientCommandManager.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            Debug.animationPause = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ChatUtil.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })))).then(ClientCommandManager.literal((String)"resume").executes(context -> {
            Debug.animationPause = -1;
            ChatUtil.debugChatMessage("animationResumed", new Object[0]);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:config").then(ClientCommandManager.literal((String)"open").executes(context -> {
            client.method_18858(() -> client.method_1507((class_437)ConfigGUI.create(null)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"reload").executes(context -> {
            ChatUtil.debugChatMessage("reloadingConfig", new Object[0]);
            ConfigManager.handler().load();
            ChatUtil.debugChatMessage("configReloaded", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.literal((String)"gpuIncompatibleMessage").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            if (ConfigManager.instance().gpuIncompatibleMessageEnabled == enable) {
                return 1;
            }
            ConfigManager.instance().gpuIncompatibleMessageEnabled = enable;
            ConfigManager.handler().save();
            ChatUtil.debugChatMessage("updatedPreferences", new Object[0]);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:dimension").then(ClientCommandManager.literal((String)"enable").executes(context -> {
            if (client.field_1687 == null) {
                return 0;
            }
            class_6880 entry = client.field_1687.method_40134();
            class_5321 key = entry.method_40230().orElse(null);
            if (key == null) {
                return 0;
            }
            if (!ConfigManager.instance().enabledDimensions.contains(key)) {
                ConfigManager.instance().enabledDimensions.add((class_5321<class_2874>)key);
            }
            ConfigManager.handler().save();
            ChatUtil.debugChatMessage("dimensionAdded", key.method_29177().toString());
            return 1;
        }))).then(ClientCommandManager.literal((String)"disable").executes(context -> {
            if (client.field_1687 == null) {
                return 0;
            }
            class_6880 entry = client.field_1687.method_40134();
            class_5321 key = entry.method_40230().orElse(null);
            if (key == null) {
                return 0;
            }
            ConfigManager.instance().enabledDimensions.remove(key);
            ConfigManager.handler().save();
            ChatUtil.debugChatMessage("dimensionRemoved", key.method_29177().toString());
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:debug").then(Commands.renderdocCommands())).then(ClientCommandManager.literal((String)"fallback").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"name", FallbackArgumentType.fallback()).executes(context -> {
            FallbackArgument fallback = FallbackArgumentType.getFallback(context, "name");
            boolean enabled = fallback.get(GLCompat.glCompat);
            ChatUtil.debugChatMessage((class_2561)class_2561.method_43470((String)String.format("Fallback %s is currently %s", fallback.method_15434(), enabled ? "enabled" : "disabled")));
            return 1;
        })).then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            FallbackArgument fallback = FallbackArgumentType.getFallback(context, "name");
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            fallback.set(GLCompat.glCompat, enable);
            client.method_1521().whenComplete((unused, throwable) -> ChatUtil.debugChatMessage((class_2561)class_2561.method_43470((String)String.format("Fallback %s is now %s", fallback.method_15434(), enable ? "enabled" : "disabled"))));
            return 1;
        })))));
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> renderdocCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"renderdoc").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            if (RenderDoc.isAvailable()) {
                ChatUtil.debugChatMessage("renderdoc.capture.trigger", new Object[0]);
                CaptureManager.capture(result -> {
                    if (result == null) {
                        ChatUtil.debugChatMessage("renderdoc.capture.failure", new Object[0]);
                    } else {
                        Path path = Path.of(result.path(), new String[0]);
                        ChatUtil.debugChatMessage("renderdoc.capture.success", class_2561.method_43470((String)path.toAbsolutePath().normalize().toString()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(Commands.createOpenFileClickEvent(path.getParent().toString()))));
                    }
                });
                return 1;
            }
            if (RenderDocLoader.isAvailable()) {
                ChatUtil.debugChatMessage((class_2561)class_2561.method_43469((String)ChatUtil.debugChatMessageKey("renderdoc.prompt.load"), (Object[])new Object[]{class_2561.method_43471((String)ChatUtil.debugChatMessageKey("renderdoc.prompt.load.action")).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(Commands.createCommandClickEvent("/betterclouds:debug renderdoc load")))}));
                return 0;
            }
            ChatUtil.debugChatMessage((class_2561)class_2561.method_43469((String)ChatUtil.debugChatMessageKey("renderdoc.prompt.install"), (Object[])new Object[]{class_2561.method_43471((String)ChatUtil.debugChatMessageKey("renderdoc.prompt.install.action")).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(Commands.createCommandClickEvent("/betterclouds:debug renderdoc install")))}));
            return 0;
        }))).then(ClientCommandManager.literal((String)"install").executes(context -> {
            CompletableFuture.runAsync(() -> {
                if (!RenderDoc.isAvailable() && !RenderDocLoader.isAvailable()) {
                    ChatUtil.debugChatMessage("renderdoc.downloading", new Object[0]);
                    try {
                        RenderDocLoader.install();
                    }
                    catch (Exception e) {
                        ChatUtil.debugChatMessage("generic.error", e.toString());
                    }
                }
                Path path = RenderDocLoader.libPath();
                ChatUtil.debugChatMessage("renderdoc.installed", class_2561.method_43470((String)path.toAbsolutePath().normalize().toString()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(Commands.createOpenFileClickEvent(path.getParent().toString()))));
            });
            return 1;
        }))).then(ClientCommandManager.literal((String)"uninstall").executes(context -> {
            try {
                RenderDocLoader.uninstall();
            }
            catch (Exception e) {
                ChatUtil.debugChatMessage("generic.error", e.toString());
                return 0;
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"load").executes(context -> {
            if (!RenderDocLoader.isAvailable()) {
                ChatUtil.debugChatMessage((class_2561)class_2561.method_43469((String)ChatUtil.debugChatMessageKey("renderdoc.prompt.install"), (Object[])new Object[]{class_2561.method_43471((String)ChatUtil.debugChatMessageKey("renderdoc.prompt.install.action")).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(Commands.createCommandClickEvent("/betterclouds:debug renderdoc install")))}));
                return 0;
            }
            if (RenderDoc.isAvailable()) {
                ChatUtil.debugChatMessage("renderdoc.load.ready", RenderDoc.getAPIVersion());
                return 1;
            }
            try {
                long expires = System.currentTimeMillis() + 43200000L;
                CaptureManager.writeLaunchConfig(new CaptureManager.LaunchConfig(true, true, expires));
            }
            catch (IOException e) {
                ChatUtil.debugChatMessage("generic.error", e.toString());
                return 0;
            }
            ChatUtil.debugChatMessage("renderdoc.load.queued", new Object[0]);
            return 1;
        }));
    }

    public static void sendGpuIncompatibleChatMessage() {
        if (!ConfigManager.instance().gpuIncompatibleMessageEnabled) {
            return;
        }
        ChatUtil.debugChatMessage((class_2561)class_2561.method_43471((String)ChatUtil.debugChatMessageKey("gpuIncompatible")).method_10852((class_2561)class_2561.method_43470((String)"\n - ")).method_10852((class_2561)class_2561.method_43471((String)ChatUtil.debugChatMessageKey("generic.disable")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1080).method_10958(Commands.createCommandClickEvent("/betterclouds:config set gpuIncompatibleMessage false")))));
    }

    public static void sendGpuPartiallyIncompatibleChatMessage() {
        if (!ConfigManager.instance().gpuIncompatibleMessageEnabled) {
            return;
        }
        ChatUtil.debugChatMessage((class_2561)class_2561.method_43471((String)ChatUtil.debugChatMessageKey("gpuPartiallyIncompatible")).method_10852((class_2561)class_2561.method_43470((String)"\n - ")).method_10852((class_2561)class_2561.method_43471((String)ChatUtil.debugChatMessageKey("generic.disable")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1080).method_10958(Commands.createCommandClickEvent("/betterclouds:config set gpuIncompatibleMessage false")))));
    }

    public static void sendHardwareMaybeIncompatibleChatMessage() {
        if (!ConfigManager.instance().gpuIncompatibleMessageEnabled) {
            return;
        }
        ChatUtil.debugChatMessage((class_2561)class_2561.method_43469((String)ChatUtil.debugChatMessageKey("hwMaybeIncompatible"), (Object[])new Object[]{GLCompat.getCpuInfo(), GLCompat.getRenderer()}).method_10852((class_2561)class_2561.method_43470((String)"\n - ")).method_10852((class_2561)class_2561.method_43471((String)ChatUtil.debugChatMessageKey("generic.disable")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1080).method_10958(Commands.createCommandClickEvent("/betterclouds:config set gpuIncompatibleMessage false")))));
    }

    private static class_2558 createCommandClickEvent(String command) {
        return new class_2558(class_2558.class_2559.field_11750, command);
    }

    private static class_2558 createOpenFileClickEvent(String path) {
        return new class_2558(class_2558.class_2559.field_11746, path);
    }

    private static class FallbackArgumentType
    extends class_7485<FallbackArgument> {
        private FallbackArgumentType() {
            super(FallbackArgument.CODEC, FallbackArgument::values);
        }

        public static class_7485<FallbackArgument> fallback() {
            return new FallbackArgumentType();
        }

        public static FallbackArgument getFallback(CommandContext<?> context, String id) {
            return (FallbackArgument)((Object)context.getArgument(id, FallbackArgument.class));
        }
    }

    private static enum FallbackArgument implements class_3542
    {
        BASE_INSTANCE(GLCompat::useBaseInstanceFallback, GLCompat::setUseBaseInstanceFallback),
        STENCIL_TEXTURE(GLCompat::useStencilTextureFallback, GLCompat::setUseStencilTextureFallback),
        TEX_STORAGE(GLCompat::useTexStorageFallback, GLCompat::setUseTexStorageFallback),
        DEPTH_WRITE(GLCompat::useDepthWriteFallback, GLCompat::setUseDepthWriteFallback);

        private static final Codec<FallbackArgument> CODEC;
        private final Function<GLCompat, Boolean> getter;
        private final BiConsumer<GLCompat, Boolean> setter;

        private FallbackArgument(Function<GLCompat, Boolean> getter, BiConsumer<GLCompat, Boolean> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public void set(GLCompat compat, boolean enable) {
            this.setter.accept(compat, enable);
        }

        public boolean get(GLCompat compat) {
            return this.getter.apply(compat);
        }

        public String method_15434() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = class_3542.method_28140(FallbackArgument::values);
        }
    }
}

