/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.telemetry;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.telemetry.Telemetry;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_128;

public interface ITelemetry {
    public static final ITelemetry INSTANCE = ITelemetry.create();

    public static ITelemetry create() {
        try {
            URL url = new URL("https://europe-west3-better-clouds.cloudfunctions.net/collect_telemetry");
            return new Telemetry(url);
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("Failed to create telemetry service", e);
            return new NoopTelemetry();
        }
    }

    public CompletableFuture<Boolean> sendSystemInfo();

    public void sendShaderCompileError(String var1);

    public void sendUnhandledException(Exception var1);

    public void sendIssueReport(class_128 var1);

    public static class NoopTelemetry
    implements ITelemetry {
        @Override
        public CompletableFuture<Boolean> sendSystemInfo() {
            return CompletableFuture.completedFuture(false);
        }

        @Override
        public void sendShaderCompileError(String error) {
        }

        @Override
        public void sendUnhandledException(Exception e) {
        }

        @Override
        public void sendIssueReport(class_128 report) {
        }
    }
}

