/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.Commands;
import com.qendolin.betterclouds.clouds.RandomPath;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.DistantHorizonsCompat;
import com.qendolin.betterclouds.compat.EnhancedCelestialsCompat;
import com.qendolin.betterclouds.compat.FabricSeasonsCompat;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.HardwareCompat;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.qendolin.betterclouds.compat.SereneSeasonsCompat;
import com.qendolin.betterclouds.compat.YACLCompat;
import com.qendolin.betterclouds.config.Config;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.config.ShaderPresetLoader;
import com.qendolin.betterclouds.duck.WorldRendererDuck;
import com.qendolin.betterclouds.platform.EventHooks;
import com.qendolin.betterclouds.platform.ModLoader;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.test.GameTest;
import com.qendolin.betterclouds.test.GameTestEnabled;
import com.qendolin.betterclouds.util.ChatUtil;
import com.qendolin.betterclouds.util.DataDirectoryMigration;
import com.qendolin.betterclouds.util.NamedLogger;
import com.qendolin.betterclouds.util.PreLaunchGuard;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_761;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class BetterClouds
extends BetterCloudsStatic {
    public static void initializeClientEarly() {
        if (!BetterCloudsStatic.IS_CLIENT) {
            throw new IllegalStateException("Minecraft environment is not 'client' but the early client initializer was called");
        }
        if (initializedEarly) {
            return;
        }
        initializedEarly = true;
        logger = new NamedLogger(LogManager.getLogger((String)"BetterClouds"), !IS_DEV);
        ConfigManager.initialize();
        ConfigManager.loadWithFailureBackup();
        version = ModLoader.getModVersion("betterclouds");
    }

    public static void initializeClient() {
        if (!BetterCloudsStatic.IS_CLIENT) {
            throw new IllegalStateException("Minecraft environment is not 'client' but the client initializer was called");
        }
        if (BetterClouds.isInitialized()) {
            return;
        }
        initialized = true;
        YACLCompat.initialize();
        DistantHorizonsCompat.initialize();
        IrisCompat.initialize();
        SereneSeasonsCompat.initialize();
        FabricSeasonsCompat.initialize();
        EnhancedCelestialsCompat.initialize();
        RandomPath.initialize();
        DataDirectoryMigration.runMigration();
        if (!BetterCloudsStatic.IS_DEV) {
            return;
        }
        BetterCloudsStatic.logger.info("Initialized in dev mode, performance might vary");
        if (GameTestEnabled.ENABLED) {
            BetterCloudsStatic.logger.info("Running mixin audit. No additional mods must be loaded!");
            MixinEnvironment.getCurrentEnvironment().audit();
        }
    }

    public static void initializeClientEvents() {
        EventHooks.instance.onClientStarted(client -> {
            if (GLCompat.glCompat == null) {
                throw new IllegalStateException("OpenGL compat not initialized yet. This should not happen!");
            }
            GLCompat.glCompat.enableDebugOutputSynchronousDev();
            if (GameTestEnabled.ENABLED) {
                GameTest.run(client);
            }
        });
        AtomicBoolean firstJoin = new AtomicBoolean(true);
        EventHooks.instance.onWorldJoin(client -> {
            if (GLCompat.glCompat.isIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Commands::sendGpuIncompatibleChatMessage));
            } else if (GLCompat.glCompat.isPartiallyIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Commands::sendGpuPartiallyIncompatibleChatMessage));
            }
            if (HardwareCompat.isMaybeIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Commands::sendHardwareMaybeIncompatibleChatMessage));
            }
            if (ModLoaded.LUNAR && ConfigManager.instance().lunarSucksMessageEnabled && firstJoin.get()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(() -> {
                    URI prismURL = URI.create("https://prismlauncher.org/");
                    URI modrinthURL = URI.create("https://modrinth.com/app");
                    ChatUtil.debugChatMessage((class_2561)class_2561.method_43470((String)"Lunar Client sucks! Use ").method_10852((class_2561)class_2561.method_43470((String)"[Prism]").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(prismURL)).method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)" or ").method_10852((class_2561)class_2561.method_43470((String)"[Modrinth]").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(modrinthURL)).method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)))).method_27693(" instead!")));
                }));
            }
            if (RenderDoc.isAvailable()) {
                ChatUtil.debugChatMessage("renderdoc.load.ready", RenderDoc.getAPIVersion());
            }
            firstJoin.set(false);
        });
        EventHooks.instance.onClientResourcesReload(() -> ShaderPresetLoader.INSTANCE);
        EventHooks.instance.onClientCommandRegistration(Commands::register);
    }

    @Nullable
    public static Renderer getCloudsRenderer() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return null;
        }
        class_761 class_7612 = client.field_1769;
        if (class_7612 instanceof WorldRendererDuck) {
            WorldRendererDuck duck = (WorldRendererDuck)class_7612;
            return duck.betterclouds$getRenderer();
        }
        return null;
    }

    public static boolean isEnabled() {
        if (!ConfigManager.isInitialized()) {
            return false;
        }
        Config config = ConfigManager.instance();
        if (!config.enabled) {
            return false;
        }
        return config.irisSupport || !IrisCompat.instance().isShadersEnabled();
    }

    @Deprecated
    public static Config getConfig() {
        return ConfigManager.instance();
    }

    @Deprecated
    public static ConfigClassHandler<Config> getConfigHandler() {
        return ConfigManager.handler();
    }

    static {
        PreLaunchGuard.check();
    }
}

