/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.clouds.ChunkedGenerator;
import com.qendolin.betterclouds.clouds.CloudinessProvider;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.EffectTintProvider;
import com.qendolin.betterclouds.clouds.Mesh;
import com.qendolin.betterclouds.clouds.PerfTimer;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.clouds.VanillaRenderTarget;
import com.qendolin.betterclouds.clouds.fog.FogProvider;
import com.qendolin.betterclouds.clouds.shaders.ShaderParameters;
import com.qendolin.betterclouds.compat.ArsNouveauCompat;
import com.qendolin.betterclouds.compat.DistantHorizonsCompat;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.compat.ProfilerWrapper;
import com.qendolin.betterclouds.config.Config;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.util.ChatUtil;
import com.qendolin.betterclouds.util.MathUtil;
import com.qendolin.betterclouds.util.RenderHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4604;
import net.minecraft.class_5294;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL32;

public class Renderer
implements AutoCloseable {
    private final class_310 client;
    private class_638 world = null;
    private float cloudsHeight;
    private final Matrix4f mvpMatrix = new Matrix4f();
    private final Matrix4f mvMatrix = new Matrix4f();
    private final Matrix4f pMatrix = new Matrix4f();
    private final Matrix4d pInverseMatrix = new Matrix4d();
    private final Matrix4f rotationProjectionMatrix = new Matrix4f();
    private final Matrix4f tempMatrix = new Matrix4f();
    private final Vector3f tempVector = new Vector3f();
    private final class_4604 tempFrustum = new class_4604(new Matrix4f().identity(), new Matrix4f().identity());
    private ShaderParameters shaderParameters = null;
    private final Resources res = new Resources();

    public Renderer(class_310 client) {
        this.client = client;
    }

    public void setWorld(class_638 world) {
        this.world = world;
    }

    public void reload(class_3300 manager) {
        BetterCloudsStatic.getLogger().info("Reloading cloud renderer...");
        BetterCloudsStatic.getLogger().debug("[1/6] Reloading shaders");
        this.shaderParameters = this.createShaderParameters(ConfigManager.instance());
        this.res.reloadShaders(manager, this.shaderParameters);
        BetterCloudsStatic.getLogger().debug("[2/6] Reloading generator");
        this.res.reloadGenerator(this.useCubeClouds());
        BetterCloudsStatic.getLogger().debug("[3/6] Reloading textures");
        this.res.reloadTextures(this.client);
        BetterCloudsStatic.getLogger().debug("[4/6] Reloading primitive meshes");
        this.res.reloadMeshPrimitives();
        BetterCloudsStatic.getLogger().debug("[5/6] Reloading framebuffer");
        this.res.reloadFramebuffer(this.scaledFramebufferWidth(), this.scaledFramebufferHeight());
        BetterCloudsStatic.getLogger().debug("[6/6] Reloading timers");
        this.res.reloadTimer();
        BetterCloudsStatic.getLogger().info("Cloud renderer initialized");
    }

    public Resources resources() {
        return this.res;
    }

    private boolean useCubeClouds() {
        return ConfigManager.instance().sizeY > 0.0f;
    }

    private int scaledFramebufferWidth() {
        return (int)(ConfigManager.instance().preset().upscaleResolutionFactor * (float)this.client.method_1522().field_1482);
    }

    private int scaledFramebufferHeight() {
        return (int)(ConfigManager.instance().preset().upscaleResolutionFactor * (float)this.client.method_1522().field_1481);
    }

    private ShaderParameters createShaderParameters(Config config) {
        return new ShaderParameters(this.client.field_1690.method_1632(), config.blockDistance(), config.sizeXZ, config.sizeY, config.celestialBodyHalo, GLCompat.glCompat.useDepthWriteFallback(), GLCompat.glCompat.useStencilTextureFallback(), DistantHorizonsCompat.instance().isReady() && DistantHorizonsCompat.instance().isEnabled(), config.preset().worldCurvatureSize);
    }

    public PrepareResult prepare(Matrix4f viewMat, Matrix4f projMat, int ticks, float tickDelta, Vector3d cam) {
        assert (RenderSystem.isOnRenderThread());
        ProfilerWrapper.getProfiler().method_15405("render_setup");
        Config config = ConfigManager.instance();
        if (this.res.failedToLoadCritical()) {
            if (RenderDoc.isFrameCapturing()) {
                GLCompat.glCompat.debugMessage("prepare failed: critical resource not loaded");
            }
            return PrepareResult.FALLBACK;
        }
        if (this.client.field_1773.method_19418().method_19334() != class_5636.field_27888) {
            return PrepareResult.NO_RENDER;
        }
        if (ArsNouveauCompat.isSkyTextureCloudsRendering()) {
            return PrepareResult.NO_RENDER;
        }
        class_5294 effects = this.world.method_28103();
        this.cloudsHeight = effects.method_28108();
        this.res.generator().bind();
        ShaderParameters currentShaderParameters = this.createShaderParameters(config);
        if (!Objects.equals(currentShaderParameters, this.shaderParameters)) {
            this.shaderParameters = currentShaderParameters;
            this.res.reloadShaders(this.client.method_1478(), this.shaderParameters);
        }
        this.res.generator().reallocateIfStale(config, this.useCubeClouds());
        float cloudiness = CloudinessProvider.getCloudiness(this.client.field_1687, tickDelta);
        this.res.generator().update(cam, ticks, tickDelta, ConfigManager.instance(), cloudiness);
        if (this.res.generator().canGenerate() && !this.res.generator().generating() && !Debug.generatorPause) {
            ProfilerWrapper.getProfiler().method_15405("generate_clouds");
            this.res.generator().generate();
            ProfilerWrapper.getProfiler().method_15405("render_setup");
        }
        if (this.res.generator().canSwap()) {
            ProfilerWrapper.getProfiler().method_15405("swap");
            this.res.generator().swap();
            ProfilerWrapper.getProfiler().method_15405("render_setup");
        }
        this.tempMatrix.set((Matrix4fc)viewMat);
        this.tempMatrix.m30(0.0f);
        this.tempMatrix.m31(0.0f);
        this.tempMatrix.m32(0.0f);
        this.tempMatrix.m33(0.0f);
        this.tempMatrix.m23(0.0f);
        this.tempMatrix.m13(0.0f);
        this.tempMatrix.m03(0.0f);
        this.rotationProjectionMatrix.set((Matrix4fc)projMat);
        this.rotationProjectionMatrix.mul((Matrix4fc)this.tempMatrix);
        this.tempMatrix.translate((float)this.res.generator().renderOriginX(cam.x), (float)((double)this.cloudsHeight - cam.y), (float)this.res.generator().renderOriginZ(cam.z));
        this.tempMatrix.m33(1.0f);
        this.pMatrix.set((Matrix4fc)projMat);
        this.pInverseMatrix.set((Matrix4fc)projMat);
        this.pInverseMatrix.invert();
        this.mvMatrix.set((Matrix4fc)this.tempMatrix);
        this.mvpMatrix.set((Matrix4fc)projMat);
        this.mvpMatrix.mul((Matrix4fc)this.mvMatrix);
        return PrepareResult.RENDER;
    }

    public void render(int ticks, float tickDelta, Vector3d cam, Vector3d frustumPos, class_4604 frustum) {
        if (this.res.failedToLoadCritical()) {
            return;
        }
        ProfilerWrapper.getProfiler().method_15405("render_setup");
        if (Debug.isProfilingEnabled()) {
            if (this.res.timer() == null) {
                this.res.reloadTimer();
            }
            if (this.res.timer() != null) {
                this.res.timer().start();
            }
        }
        RenderHelper.unbindShader();
        RenderHelper.saveShader();
        RenderHelper.saveColorMask();
        RenderHelper.saveDepthMask();
        Config config = ConfigManager.instance();
        if (this.isFramebufferStale()) {
            this.res.reloadFramebuffer(this.scaledFramebufferWidth(), this.scaledFramebufferHeight());
        }
        FogProvider.Fog fog = FogProvider.instance.getFog(this.client, config, tickDelta);
        ProfilerWrapper.getProfiler().method_15405("draw_coverage");
        GlStateManager._viewport((int)0, (int)0, (int)this.res.fboWidth(), (int)this.res.fboHeight());
        GlStateManager._glBindFramebuffer((int)36009, (int)this.res.oitFbo());
        GL32.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL32.glClearDepth((double)1.0);
        this.drawCoverage((float)ticks + tickDelta, cam, frustumPos, frustum, fog);
        VanillaRenderTarget rt = new VanillaRenderTarget(this.client, config);
        rt.begin();
        ProfilerWrapper.getProfiler().method_15405("draw_debug");
        Debug.render(this.res, cam);
        ProfilerWrapper.getProfiler().method_15405("draw_shading");
        this.drawShading(tickDelta, fog);
        ProfilerWrapper.getProfiler().method_15405("render_cleanup");
        rt.end();
        this.res.generator().unbind();
        GlStateManager._disableBlend();
        GlStateManager._enableDepthTest();
        RenderHelper.depthMask(true);
        RenderHelper.restoreDepthMask();
        GlStateManager._depthFunc((int)515);
        GlStateManager._activeTexture((int)33984);
        RenderHelper.colorMask(true, true, true, true);
        RenderHelper.restoreColorMask();
        RenderHelper.restoreShader();
        if (!GLCompat.glCompat.useStencilTextureFallback()) {
            GL32.glDisable((int)2960);
            GL32.glStencilFunc((int)519, (int)0, (int)255);
            GL32.glStencilOp((int)7680, (int)7680, (int)7680);
        }
        if (Debug.isProfilingEnabled() && this.res.timer() != null) {
            this.res.timer().stop();
            if (this.res.timer().frames() >= Debug.profileInterval) {
                PerfTimer.Stats gpu = PerfTimer.Stats.of(this.res.timer().gpu());
                PerfTimer.Stats cpu = PerfTimer.Stats.of(this.res.timer().cpu());
                BetterCloudsStatic.getLogger().info("GPU Times (msec):\n" + String.valueOf(gpu));
                BetterCloudsStatic.getLogger().info("CPU Times (msec):\n" + String.valueOf(cpu));
                ChatUtil.debugChatMessage("profiling.gpuTimes", gpu.formatted());
                ChatUtil.debugChatMessage("profiling.cpuTimes", cpu.formatted());
                this.res.timer().reset();
            }
        }
    }

    private boolean isFramebufferStale() {
        return this.res.fboWidth() != this.scaledFramebufferWidth() || this.res.fboHeight() != this.scaledFramebufferHeight();
    }

    private void drawCoverage(float ticks, Vector3d cam, Vector3d frustumPos, class_4604 frustum, FogProvider.Fog fog) {
        GlStateManager._enableDepthTest();
        RenderHelper.colorMask(true, true, true, true);
        RenderHelper.depthMask(true);
        GL32.glEnable((int)34383);
        if (GLCompat.glCompat.useStencilTextureFallback()) {
            GlStateManager._depthFunc((int)519);
            GlStateManager._enableBlend();
            GL32.glBlendEquation((int)32774);
            GLCompat.glCompat.blendFunci(0, 1, 0);
            GLCompat.glCompat.blendFunci(1, 1, 1);
            GL32.glDisable((int)2960);
        } else {
            GlStateManager._depthFunc((int)515);
            GlStateManager._disableBlend();
            GL32.glEnable((int)2960);
            GL32.glStencilMask((int)255);
            GL32.glClearStencil((int)0);
            GL32.glStencilOp((int)7680, (int)7682, (int)7682);
            GL32.glStencilFunc((int)519, (int)255, (int)255);
        }
        if (this.useCubeClouds()) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
        GL32.glClear((int)17664);
        Config generatorConfig = this.getGeneratorConfig();
        Config config = ConfigManager.instance();
        this.res.coverageShader().bind();
        this.res.coverageShader().uMVPMatrix.setMat4(this.mvpMatrix);
        this.res.coverageShader().uOriginOffset.setVec3((float)(-this.res.generator().renderOriginX(cam.x)), (float)cam.y - this.cloudsHeight, (float)(-this.res.generator().renderOriginZ(cam.z)));
        this.res.coverageShader().uBoundingBox.setVec4((float)cam.x, (float)cam.z, (float)generatorConfig.blockDistance() - (float)generatorConfig.chunkSize / 2.0f, generatorConfig.yRange + config.sizeY);
        this.res.coverageShader().uTime.setFloat(ticks / 20.0f);
        this.res.coverageShader().uMiscellaneous.setVec3(config.scaleFalloffMin, config.windEffectFactor, config.windSpeedFactor);
        if (fog == null) {
            this.res.coverageShader().uFogRange.setVec2(config.blockDistance() - 8, config.blockDistance());
        } else {
            this.res.coverageShader().uFogRange.setVec2(fog.start(), fog.end());
        }
        GlStateManager._activeTexture((int)33984);
        RenderHelper.bindTexture(this.client.method_1522().method_30278());
        if (DistantHorizonsCompat.instance().isReady() && DistantHorizonsCompat.instance().isEnabled()) {
            this.res.coverageShader().uMVMatrix.setMat4(this.mvMatrix);
            this.res.coverageShader().uMcPMatrix.setMat4(this.pMatrix);
            Optional<Integer> depthId = DistantHorizonsCompat.instance().getDepthTextureId();
            GlStateManager._activeTexture((int)33990);
            if (depthId.isPresent()) {
                Matrix4f dhProjectionMatrix = DistantHorizonsCompat.instance().getProjectionMatrix();
                RenderHelper.bindTexture(depthId.get());
                if (DistantHorizonsCompat.instance().isTextureCreateFlagSet()) {
                    GL32.glBindTexture((int)3553, (int)depthId.get());
                    DistantHorizonsCompat.instance().resetTextureCreateFlag();
                }
                this.res.coverageShader().uDhPMatrix.setMat4(dhProjectionMatrix);
            } else {
                RenderHelper.bindTexture(0);
                this.res.coverageShader().uDhPMatrix.setMat4(DistantHorizonsCompat.NOOP_MATRIX);
            }
        }
        GlStateManager._activeTexture((int)33989);
        RenderHelper.bindTexture(this.client.method_1531().method_4619(Resources.NOISE_TEXTURE));
        this.res.generator().bind();
        if (GLCompat.glCompat.useBaseInstanceFallback()) {
            this.res.generator().buffer().bindDrawBuffer();
        }
        Renderer.setFrustumTo(this.tempFrustum, frustum);
        class_4604 frustumAtOrigin = this.tempFrustum;
        frustumAtOrigin.method_23088(frustumPos.x - this.res.generator().originX(), frustumPos.y, frustumPos.z - this.res.generator().originZ());
        if (!this.res.generator().canRender()) {
            GlStateManager._enableCull();
            return;
        }
        boolean frustumCulling = config.useFrustumCulling;
        if (IrisCompat.instance().isFrustumCullingDisabled() || config.preset().worldCurvatureSize != 0) {
            frustumCulling = false;
        }
        if (frustumCulling) {
            this.drawCloudsWithFrustumCulling(frustumAtOrigin, config);
        } else {
            this.drawCloudsWithoutFrustumCulling();
        }
        GL32.glDisable((int)34383);
        GlStateManager._enableCull();
    }

    private void drawCloudsWithFrustumCulling(class_4604 frustumAtOrigin, Config config) {
        int runStart = -1;
        int runCount = 0;
        for (ChunkedGenerator.ChunkIndex chunk : this.res.generator().chunks()) {
            class_238 bounds = chunk.bounds(this.cloudsHeight, config.sizeXZ, config.sizeY);
            if (!frustumAtOrigin.method_23093(bounds)) {
                Debug.addFrustumCulledBox(bounds, false);
                if (runCount != 0) {
                    if (GLCompat.glCompat.useBaseInstanceFallback()) {
                        this.res.generator().buffer().setVAPointerToInstance(runStart);
                    }
                    GLCompat.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), runCount, runStart);
                }
                runStart = -1;
                runCount = 0;
                continue;
            }
            Debug.addFrustumCulledBox(bounds, true);
            if (runStart == -1) {
                runStart = chunk.start();
            }
            runCount += chunk.count();
        }
        if (runCount != 0) {
            if (GLCompat.glCompat.useBaseInstanceFallback()) {
                this.res.generator().buffer().setVAPointerToInstance(runStart);
            }
            GLCompat.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), runCount, runStart);
        }
    }

    private void drawCloudsWithoutFrustumCulling() {
        List<ChunkedGenerator.ChunkIndex> chunks = this.res.generator().chunks();
        if (chunks.isEmpty()) {
            return;
        }
        ChunkedGenerator.ChunkIndex first = chunks.get(0);
        ChunkedGenerator.ChunkIndex last = chunks.get(chunks.size() - 1);
        int start = first.start();
        int count = last.start() + last.count();
        if (GLCompat.glCompat.useBaseInstanceFallback()) {
            this.res.generator().buffer().setVAPointerToInstance(start);
        }
        GLCompat.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), count, start);
    }

    private void drawShading(float tickDelta, FogProvider.Fog fog) {
        Config config = ConfigManager.instance();
        GlStateManager._depthFunc((int)515);
        if (!GLCompat.glCompat.useDepthWriteFallback()) {
            RenderHelper.depthMask(true);
            GlStateManager._enableDepthTest();
        } else {
            GlStateManager._disableDepthTest();
        }
        GlStateManager._enableBlend();
        GL32.glBlendEquation((int)32774);
        GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL32.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        RenderHelper.colorMask(false, false, false, false);
        GL32.glColorMaski((int)0, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (!GLCompat.glCompat.useStencilTextureFallback()) {
            GL32.glDisable((int)2960);
        }
        GlStateManager._activeTexture((int)33985);
        if (GLCompat.glCompat.useDepthWriteFallback()) {
            RenderHelper.bindTexture(0);
        } else {
            RenderHelper.bindTexture(this.res.oitCoverageDepthTexture());
        }
        GlStateManager._activeTexture((int)33986);
        RenderHelper.bindTexture(this.res.oitDataTexture());
        GlStateManager._activeTexture((int)33987);
        RenderHelper.bindTexture(this.res.oitCoverageTexture());
        GlStateManager._activeTexture((int)33988);
        RenderHelper.bindTexture(this.client.method_1531().method_4619(Resources.LIGHTING_TEXTURE));
        Vector3f effectTint = EffectTintProvider.getEffectTint(this.client, fog, tickDelta);
        long skyTime = this.world.method_30271() % 24000L;
        float skyAngleRad = this.world.method_8442(tickDelta);
        float sunPathAngleRad = (float)Math.toRadians(config.preset().sunPathAngle);
        float dayNightFactor = MathUtil.interpolateDayNightFactor(skyTime, config.preset().sunriseStartTime, config.preset().sunriseEndTime, config.preset().sunsetStartTime, config.preset().sunsetEndTime);
        float brightness = (1.0f - dayNightFactor) * config.preset().nightBrightness + dayNightFactor * config.preset().dayBrightness;
        float sunAxisY = class_3532.method_15374((float)sunPathAngleRad);
        float sunAxisZ = class_3532.method_15362((float)sunPathAngleRad);
        Vector3f sunDir = this.tempVector.set(1.0f, 0.0f, 0.0f).rotateAxis(skyAngleRad + 1.5707964f, 0.0f, sunAxisY, sunAxisZ);
        float dayTime = this.world.method_8532() % 24000L;
        float mappedTime = MathUtil.mapTimeOfDay(dayTime, config.preset().sunriseStartTime, config.preset().sunriseEndTime, config.preset().sunsetStartTime, config.preset().sunsetEndTime);
        this.res.shadingShader().bind();
        this.res.shadingShader().uVPMatrix.setMat4(this.rotationProjectionMatrix);
        this.res.shadingShader().uSunDirection.setVec4(sunDir.x, sunDir.y, sunDir.z, mappedTime / 24000.0f);
        this.res.shadingShader().uSunAxis.setVec3(0.0f, sunAxisY, sunAxisZ);
        this.res.shadingShader().uOpacity.setVec3(config.preset().opacity, config.preset().opacityFactor, config.preset().opacityExponent);
        this.res.shadingShader().uColorGrading.setVec4(brightness, 1.0f / config.preset().gamma(), 0.0f, config.preset().saturation);
        this.res.shadingShader().uTint.setVec3(config.preset().tintRed * effectTint.x, config.preset().tintGreen * effectTint.y, config.preset().tintBlue * effectTint.z);
        this.res.shadingShader().uNoiseFactor.setFloat(config.colorVariationFactor);
        GL32.glBindVertexArray((int)this.res.cubeVao());
        GL32.glDrawArrays((int)4, (int)0, (int)Mesh.CUBE_MESH_VERTEX_COUNT);
        if (GLCompat.glCompat.useDepthWriteFallback()) {
            RenderHelper.colorMask(false, false, false, false);
            GlStateManager._activeTexture((int)33990);
            RenderHelper.bindTexture(this.res.oitCoverageDepthTexture());
            GL32.glTexParameteri((int)3553, (int)GLCompat.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6402);
            this.res.depthShader().bind();
            GL32.glDrawArrays((int)4, (int)0, (int)6);
            GL32.glTexParameteri((int)3553, (int)GLCompat.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6401);
        }
    }

    private Config getGeneratorConfig() {
        Config config = this.res.generator().config();
        if (config != null) {
            return config;
        }
        return ConfigManager.instance();
    }

    private static void setFrustumTo(class_4604 dst, class_4604 src) {
        dst.field_40823 = src.field_40823;
        dst.field_40824.set((Matrix4fc)src.field_40824);
        dst.field_20995 = src.field_20995;
        dst.field_20996 = src.field_20996;
        dst.field_20997 = src.field_20997;
        dst.field_34821 = src.field_34821;
    }

    @Override
    public void close() {
        this.res.close();
    }

    public static enum PrepareResult {
        RENDER,
        NO_RENDER,
        FALLBACK;

    }
}

