/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.compat.SereneSeasonsCompat;
import com.qendolin.betterclouds.config.ConfigManager;
import java.util.Locale;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonsCompatImpl
extends SereneSeasonsCompat {
    private Season.SubSeason getRelativeSeason(Season.SubSeason season, int d) {
        if (d == 0) {
            return season;
        }
        int index = season.ordinal();
        int length = Season.SubSeason.values().length;
        index = ((index + d) % length + length) % length;
        return Season.SubSeason.values()[index];
    }

    private float getSeasonCloudiness(Season.SubSeason season) {
        String key = season.name().toLowerCase(Locale.ROOT);
        return SUB_SEASON_CLOUDINESS_LOOKUP.getOrDefault(key, config -> Float.valueOf(1.0f)).apply(ConfigManager.instance().sereneSeasonsConfig).floatValue();
    }

    private int getSubSeasonTicks(ISeasonState state) {
        int time = state.getSeasonCycleTicks();
        int duration = state.getSubSeasonDuration();
        return time % duration;
    }

    @Override
    public float getCloudinessFactor(Level world) {
        float blend;
        int seasonDuration;
        ISeasonState state = SeasonHelper.getSeasonState((Level)world);
        if (state == null) {
            return 1.0f;
        }
        Season.SubSeason season = state.getSubSeason();
        if (season == null) {
            return 1.0f;
        }
        int seasonTicks = this.getSubSeasonTicks(state);
        int half = seasonTicks < (seasonDuration = state.getSubSeasonDuration()) / 2 ? 0 : 1;
        int transitionTicks = (int)(ConfigManager.instance().sereneSeasonsConfig.transitionDays * (float)state.getDayDuration());
        if ((transitionTicks = Math.min(transitionTicks, seasonDuration)) <= 0) {
            return this.getSeasonCloudiness(season);
        }
        float start = this.getSeasonCloudiness(this.getRelativeSeason(season, half - 1));
        float end = this.getSeasonCloudiness(this.getRelativeSeason(season, half));
        if (half == 0) {
            blend = (float)seasonTicks / (float)transitionTicks + 0.5f;
        } else {
            blend = (float)(seasonDuration - seasonTicks) / (float)transitionTicks + 0.5f;
            blend = 1.0f - blend;
        }
        return Mth.clampedLerp((float)start, (float)end, (float)blend);
    }
}

