/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.config.ShaderPresetConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ShaderPresetLoader
implements PreparableReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ShaderPresetConfig.class, ShaderPresetConfig.INSTANCE_CREATOR).create();
    public static final ResourceLocation ID = ResourceLocation.tryBuild((String)"betterclouds", (String)"shader_presets");
    public static final ResourceLocation RESOURCE_ID = ResourceLocation.tryBuild((String)"betterclouds", (String)"betterclouds/shader_presets.json");
    public static final ShaderPresetLoader INSTANCE = new ShaderPresetLoader();
    private Map<String, ShaderPresetConfig> presets = null;

    public Map<String, ShaderPresetConfig> presets() {
        if (this.presets == null) {
            return Map.of();
        }
        return ImmutableMap.copyOf(this.presets);
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier helper, ResourceManager manager, ProfilerFiller loadProfiler, ProfilerFiller applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return ((CompletableFuture)this.load(manager, loadExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)helper).wait(arg_0))).thenCompose(o -> this.apply((Map<String, ShaderPresetConfig>)o, manager, applyExecutor));
    }

    public CompletableFuture<Map<String, ShaderPresetConfig>> load(ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap mergedPresets = new HashMap();
            Type mapType = new TypeToken<Map<String, ShaderPresetConfig>>(){}.getType();
            for (Resource resource : manager.getResourceStack(RESOURCE_ID)) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        Map presets = (Map)GSON.fromJson((Reader)reader, mapType);
                        if (presets == null) continue;
                        mergedPresets.putAll(presets);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    BetterCloudsStatic.getLogger().warn("Failed to parse shader presets {} in pack '{}' ({})", RESOURCE_ID, resource.source().location().title(), resource.source().packId(), exception);
                }
            }
            mergedPresets.values().removeAll(Collections.singleton(null));
            for (Map.Entry entry : mergedPresets.entrySet()) {
                ((ShaderPresetConfig)entry.getValue()).editable = false;
                ((ShaderPresetConfig)entry.getValue()).key = (String)entry.getKey();
            }
            return mergedPresets;
        });
    }

    public CompletableFuture<Void> apply(Map<String, ShaderPresetConfig> data, ResourceManager manager, Executor executor) {
        this.presets = data;
        if (ConfigManager.instance() != null) {
            ConfigManager.instance().loadDefaultPresets();
        }
        return CompletableFuture.completedFuture(null);
    }
}

