/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds.fog;

import com.qendolin.betterclouds.clouds.fog.FogProvider1216;
import com.qendolin.betterclouds.compat.SodiumExtraCompat;
import com.qendolin.betterclouds.config.Config;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public interface FogProvider {
    public static final FogProvider instance = new FogProvider1216();

    default public Fog getFogInternal(Minecraft client, Config config, float tickDelta, Camera camera, float distance) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    default public Fog getFog(Minecraft client, Config config, float tickDelta) {
        Fog fog;
        if (client.level == null) {
            return null;
        }
        Camera camera = client.gameRenderer.getMainCamera();
        float cloudDistance = config.blockDistance();
        try {
            SodiumExtraCompat.PREVENT_FOG_MODIFICATION.set(true);
            fog = this.getFogInternal(client, config, tickDelta, camera, cloudDistance);
        }
        finally {
            SodiumExtraCompat.PREVENT_FOG_MODIFICATION.set(false);
        }
        if (fog == null || (double)fog.end == 0.0 || fog.end < fog.start) {
            return null;
        }
        float start = fog.start;
        float end = fog.end;
        float range = end - start;
        start = Math.max((end *= config.fogEndFactor) - config.fogRangeFactor * range, 0.0f);
        return new Fog(start, end, fog.red, fog.green, fog.blue, fog.alpha);
    }

    public record Fog(float start, float end, float red, float green, float blue, float alpha) {
    }
}

