/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.util;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.textures.GpuTexture;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationGpuTexture;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL32;

public abstract class RenderHelper {
    private static Matrix4f projectionMatrix = new Matrix4f().identity();
    private static Matrix4f viewMatrix = new Matrix4f().identity();
    private static FogDataAndColor fogDataAndColor = null;
    private static int savedShaderId = 0;
    private static boolean savedColorMaskRed = true;
    private static boolean savedColorMaskGreen = true;
    private static boolean savedColorMaskBlue = true;
    private static boolean savedColorMaskAlpha = true;
    private static boolean savedDepthMask = true;
    private static final ByteBuffer colorMaskBuffer = ByteBuffer.allocateDirect(4);

    public static int getTextureId(AbstractTexture texture) {
        GpuTexture gpuTexture = texture.getTexture();
        return RenderHelper.getTextureId(gpuTexture);
    }

    public static int getTextureId(GpuTexture texture) {
        if (texture instanceof ValidationGpuTexture) {
            ValidationGpuTexture validationGpuTexture = (ValidationGpuTexture)texture;
            texture = validationGpuTexture.getRealTexture();
        }
        if (texture instanceof GlTexture) {
            GlTexture glTexture = (GlTexture)texture;
            return glTexture.glId();
        }
        throw new IllegalStateException("Texture is not a GlTexture");
    }

    public static void bindTexture(AbstractTexture texture) {
        RenderHelper.bindTexture(RenderHelper.getTextureId(texture));
    }

    public static void bindTexture(GpuTexture texture) {
        RenderHelper.bindTexture(RenderHelper.getTextureId(texture));
    }

    public static void bindTexture(int id) {
        GlStateManager._bindTexture((int)id);
    }

    public static void saveShader() {
        savedShaderId = GL32.glGetInteger((int)35725);
    }

    public static void restoreShader() {
        GL32.glUseProgram((int)savedShaderId);
    }

    public static void unbindShader() {
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL32.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void saveColorMask() {
        colorMaskBuffer.clear();
        GL32.glGetBooleanv((int)3107, (ByteBuffer)colorMaskBuffer);
        savedColorMaskRed = colorMaskBuffer.get(0) == 1;
        savedColorMaskGreen = colorMaskBuffer.get(1) == 1;
        savedColorMaskBlue = colorMaskBuffer.get(2) == 1;
        savedColorMaskAlpha = colorMaskBuffer.get(3) == 1;
    }

    public static void restoreColorMask() {
        RenderHelper.colorMask(savedColorMaskRed, savedColorMaskGreen, savedColorMaskBlue, savedColorMaskAlpha);
    }

    public static void depthMask(boolean flag) {
        GL32.glDepthMask((boolean)flag);
    }

    public static void saveDepthMask() {
        savedDepthMask = GL32.glGetBoolean((int)2930);
    }

    public static void restoreDepthMask() {
        RenderHelper.depthMask(savedDepthMask);
    }

    public static Matrix4f getProjectionMatrix() {
        return projectionMatrix;
    }

    public static Matrix4f getViewMatrix() {
        return viewMatrix;
    }

    public static void setProjectionMatrix(Matrix4f matrix) {
        projectionMatrix = matrix;
    }

    public static void setViewMatrix(Matrix4f matrix) {
        viewMatrix = matrix;
    }

    public static void setFogDataAndColor(FogDataAndColor data) {
        fogDataAndColor = data;
    }

    public static FogDataAndColor getFogDataAndColor() {
        return fogDataAndColor;
    }

    public record FogDataAndColor(FogData fogData, Vector4f color) {
    }
}

