/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.telemetry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.platform.ModVersion;
import com.qendolin.betterclouds.telemetry.ITelemetry;
import com.qendolin.betterclouds.telemetry.McLogsUploader;
import com.qendolin.betterclouds.telemetry.TelemetryCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.CrashReport;
import net.minecraft.DetectedVersion;
import net.minecraft.ReportType;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class Telemetry
implements ITelemetry {
    public static final String ENDPOINT = "https://europe-west3-better-clouds.cloudfunctions.net/collect_telemetry";
    public static final String ENABLED_LABELS_ENDPOINT = "https://storage.googleapis.com/better-clouds-static/v1/enabled_telemetry_labels.txt";
    public static final int CONNECT_TIMEOUT_MS = 5000;
    public static final int READ_TIMEOUT_MS = 5000;
    public static final int VERSION = 3;
    protected boolean enabled = true;
    protected final ReentrantLock enabledLabelsLock = new ReentrantLock();
    protected final Set<String> enabledLabels = new HashSet<String>();
    protected final TelemetryCache cache = new TelemetryCache();
    protected final URL url;
    protected final Gson gson = new GsonBuilder().create();

    protected Telemetry(URL url) {
        this.url = url;
        if (BetterCloudsStatic.IS_DEV) {
            BetterCloudsStatic.getLogger().info("Started in dev mode, telemetry will not be sent");
            this.enabled = false;
        }
        this.loadEnabledLabels();
    }

    private void loadEnabledLabels() {
        CompletableFuture.runAsync(() -> {
            try {
                this.enabledLabelsLock.lock();
                URL url = new URI(ENABLED_LABELS_ENDPOINT).toURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (responseCode < 200 || responseCode >= 300) {
                    BetterCloudsStatic.getLogger().warn("Failed to get enabled telemetry labels: responseCode={}", responseCode);
                    return;
                }
                HashSet<String> labels = new HashSet<String>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isBlank()) continue;
                        labels.add(line.toUpperCase());
                    }
                }
                this.enabledLabels.clear();
                this.enabledLabels.addAll(labels);
            }
            catch (Exception e) {
                BetterCloudsStatic.getLogger().warn("Failed to get enabled telemetry labels", e.getMessage());
            }
            finally {
                this.enabledLabelsLock.unlock();
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> sendSystemInfo() {
        return this.sendPayload("", Label.SYSTEM_INFORMATION);
    }

    protected CompletableFuture<Boolean> sendPayload(String payload, Label ... labels) {
        if (!this.enabled) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.allLabelsEnabled(labels)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            List<String> stringLabels = Arrays.stream(labels).map(Label::toString).toList();
            RequestBody body = new RequestBody(new SystemDetails(), stringLabels, payload, BetterClouds.getVersion(), 3);
            String json = this.gson.toJson((Object)body);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            return this.postAsync(bytes);
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("Failed to send system information", e);
            return CompletableFuture.completedFuture(false);
        }
    }

    private boolean allLabelsEnabled(Label[] labels) {
        try {
            this.enabledLabelsLock.lock();
            boolean bl = Arrays.stream(labels).map(Label::toString).allMatch(this.enabledLabels::contains);
            return bl;
        }
        finally {
            this.enabledLabelsLock.unlock();
        }
    }

    protected CompletableFuture<Boolean> postAsync(byte[] body) {
        return CompletableFuture.supplyAsync(() -> this.post(body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean post(byte[] body) {
        boolean bl;
        OutputStream outputStream;
        block7: {
            HttpURLConnection conn = this.createConnection();
            if (conn == null) {
                return false;
            }
            outputStream = null;
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestProperty("Content-Length", "" + body.length);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            outputStream = conn.getOutputStream();
            BetterCloudsStatic.getLogger().info("Sending telemetry, see https://github.com/Qendolin/better-clouds/blob/main/Telemetry.md for mor information");
            IOUtils.write((byte[])body, (OutputStream)outputStream);
            InputStreamReader is = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
            String response = IOUtils.toString((Reader)is);
            if (response != null && response.trim().equalsIgnoreCase("ok")) break block7;
            BetterCloudsStatic.getLogger().warn("Failed to post: bad request");
            boolean bl2 = false;
            IOUtils.closeQuietly((OutputStream)outputStream);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Throwable e) {
            try {
                BetterCloudsStatic.getLogger().error("Failed to post to telemetry endpoint", e);
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(outputStream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return bl;
    }

    protected HttpURLConnection createConnection() {
        if (!this.enabled) {
            return null;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            return connection;
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("Failed to connect to telemetry endpoint", e);
            this.enabled = false;
            return null;
        }
    }

    @Override
    public void sendShaderCompileError(String error) {
        if (error == null || error.isBlank()) {
            return;
        }
        this.cachedSend(error, Label.SHADER_COMPILE_ERROR);
    }

    private void cachedSend(String error, Label label) {
        if (this.lazyOpenCache()) {
            String hash = this.cache.hash(error);
            if (this.cache.contains(label.toString(), hash)) {
                return;
            }
        }
        this.sendPayload(error, label).whenComplete((success, throwable) -> {
            if (success.booleanValue()) {
                String hash = this.cache.hash(error);
                this.cache.add(label.toString(), hash);
            }
        });
    }

    protected boolean lazyOpenCache() {
        if (!this.cache.isOpened()) {
            try {
                this.cache.open();
            }
            catch (IOException e) {
                BetterCloudsStatic.getLogger().warn("Failed to open telemetry cache", (Throwable)e);
            }
        }
        return this.cache.isAvailable();
    }

    @Override
    public void sendUnhandledException(Exception e) {
        if (e == null) {
            return;
        }
        String message = ExceptionUtils.getStackTrace((Throwable)e);
        this.cachedSend(message, Label.UNHANDLED_EXCEPTION);
    }

    @Override
    public void sendIssueReport(CrashReport report) {
        if (report == null) {
            return;
        }
        String shortReportText = report.getTitle() + "\n\n" + report.getExceptionMessage();
        String fullReportText = report.getFriendlyReport(ReportType.TEST);
        ((CompletableFuture)new McLogsUploader().upload(fullReportText).thenAccept(logUrl -> Minecraft.getInstance().schedule(() -> this.sendPayload(shortReportText + "\n\nFull Report at: " + logUrl, Label.AUTO_REPORT)))).whenComplete((success, e) -> {
            if (e != null) {
                BetterCloudsStatic.getLogger().warn("Failed to upload issue report", (Throwable)e);
            }
        });
    }

    public static enum Label {
        SHADER_COMPILE_ERROR("SHADER_COMPILE_ERROR"),
        SYSTEM_INFORMATION("SYSTEM_INFORMATION"),
        UNHANDLED_EXCEPTION("UNHANDLED_EXCEPTION"),
        AUTO_REPORT("AUTO_REPORT");

        private final String string;

        private Label(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static final class RequestBody {
        public final SystemDetails systemDetails;
        public final List<String> labels;
        public final String payload;
        public final int telemetryVersion;
        public final MetaInfo metaInfo;
        public final List<String> mods;

        public RequestBody(SystemDetails systemDetails, List<String> labels, String payload, ModVersion modVersion, int telemetryVersion) {
            this.systemDetails = systemDetails;
            this.labels = labels;
            this.payload = payload;
            this.telemetryVersion = telemetryVersion;
            this.metaInfo = new MetaInfo(modVersion);
            this.mods = List.of();
        }

        public static final class MetaInfo {
            public final ModVersion.SemVer modSemVer;
            public final String mcVersion;
            public final ModVersion.SemVer mcSemVer;
            public final String modVersion;

            public MetaInfo(ModVersion modVersion) {
                this.modVersion = modVersion.getFriendlyString();
                this.modSemVer = modVersion.asSemVer().orElse(null);
                this.mcVersion = DetectedVersion.tryDetectVersion().name();
                this.mcSemVer = ModVersion.fromString(this.mcVersion).asSemVer().orElse(null);
            }
        }
    }

    public static final class SystemDetails {
        public final String os = SystemUtils.OS_NAME;
        public final String vendor = GLCompat.glCompat.getString(7936);
        public final String renderer = GLCompat.glCompat.getString(7937);
        public final String glVersion = GLCompat.glCompat.getString(7938);
        public final int glVersionMajor = GLCompat.glCompat.getInteger(33307);
        public final int glVersionMinor = GLCompat.glCompat.getInteger(33308);
        public final String glVersionCombined = String.format("%d%d", this.glVersionMajor, this.glVersionMinor);
        public final int glVersionLwjgl;
        public final String glslVersion;
        public final List<String> extensions;
        public final List<String> functions;
        public final List<String> fallbacks;
        public final String cpuName;
        public final boolean compatible;
        public final boolean partiallyIncompatible;

        public SystemDetails() {
            String cpuName;
            this.glVersionLwjgl = GLCompat.glCompat.openGlMax;
            this.glslVersion = GLCompat.glCompat.getString(35724);
            this.extensions = GLCompat.glCompat.supportedCheckedExtensions;
            this.functions = GLCompat.glCompat.supportedCheckedFunctions;
            this.fallbacks = GLCompat.glCompat.usedFallbacks();
            this.compatible = !GLCompat.glCompat.isIncompatible();
            this.partiallyIncompatible = GLCompat.glCompat.isPartiallyIncompatible();
            try {
                CentralProcessor cpu = new SystemInfo().getHardware().getProcessor();
                cpuName = cpu.getProcessorIdentifier().getName().replaceAll("\\s+", " ");
            }
            catch (Exception ignored) {
                cpuName = "unavailable";
            }
            this.cpuName = cpuName;
        }
    }
}

