/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.util;

import net.minecraft.class_3532;
import org.joml.Matrix4d;
import org.joml.Vector2d;
import org.joml.Vector4d;

public interface MathUtil {
    public static float interpolateDayNightFactor(float time, float riseStart, float riseEnd, float setStart, float setEnd) {
        if (time <= 6000.0f || time > 18000.0f) {
            if (time > 18000.0f) {
                time -= 24000.0f;
            }
            return MathUtil.smoothstep(time, riseStart, riseEnd);
        }
        return 1.0f - MathUtil.smoothstep(time, setStart, setEnd);
    }

    public static float mapTimeOfDay(float time, float riseStart, float riseEnd, float setStart, float setEnd) {
        if (time <= 6000.0f || time > 18000.0f) {
            if (time > 18000.0f) {
                time -= 24000.0f;
            }
            time = time < riseStart ? MathUtil.map(time, -6000.0f, riseStart, -6000.0f, -785.0f) : (time > riseEnd ? MathUtil.map(time, riseEnd, 6000.0f, 1163.0f, 6000.0f) : MathUtil.map(time, riseStart, riseEnd, -785.0f, 1163.0f));
        } else {
            time = time < setStart ? MathUtil.map(time, 6000.0f, setStart, 6000.0f, 10837.0f) : (time > setEnd ? MathUtil.map(time, setEnd, 18000.0f, 12785.0f, 18000.0f) : MathUtil.map(time, setStart, setEnd, 10837.0f, 12785.0f));
        }
        return time;
    }

    public static float map(float x, float fromMin, float fromMax, float toMin, float toMax) {
        float f = (x - fromMin) / (fromMax - fromMin);
        return f * (toMax - toMin) + toMin;
    }

    public static float smoothstep(float x, float e0, float e1) {
        x = class_3532.method_15363((float)((x - e0) / (e1 - e0)), (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    public static Vector2d calculateClippingPlanes(Matrix4d projInverseMatrix) {
        Vector4d farPlane = new Vector4d(0.0, 0.0, 1.0, 1.0);
        Vector4d nearPlane = new Vector4d(0.0, 0.0, -1.0, 1.0);
        projInverseMatrix.transform(farPlane);
        projInverseMatrix.transform(nearPlane);
        return new Vector2d((double)((float)(-nearPlane.z / nearPlane.w)), (double)((float)(-farPlane.z / farPlane.w)));
    }
}

