/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.qendolin.betterclouds.compat.FabricSeasonsCompat;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.qendolin.betterclouds.compat.SereneSeasonsCompat;
import com.qendolin.betterclouds.compat.WorldDuck;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public abstract class CloudinessProvider {
    public static float getCloudiness(ClientLevel world, float tickDelta) {
        if (world == null) {
            return 1.0f;
        }
        float weather = Math.max(0.6f * CloudinessProvider.getTrueRainGradient(world, tickDelta), CloudinessProvider.getTrueThunderGradient(world, tickDelta));
        float cloudiness = weather * 0.3f + 0.5f;
        cloudiness *= SereneSeasonsCompat.instance().getCloudinessFactor((Level)world);
        return Mth.clamp((float)(cloudiness *= FabricSeasonsCompat.instance().getCloudinessFactor((Level)world)), (float)0.0f, (float)1.0f);
    }

    private static float getTrueRainGradient(ClientLevel world, float tickDelta) {
        if (ModLoaded.HEAD_IN_THE_CLOUDS) {
            return ((WorldDuck)world).betterclouds$getOriginalRainGradient(tickDelta);
        }
        return world.getRainLevel(tickDelta);
    }

    private static float getTrueThunderGradient(ClientLevel world, float tickDelta) {
        if (ModLoaded.HEAD_IN_THE_CLOUDS) {
            return ((WorldDuck)world).betterclouds$getOriginalThunderGradient(tickDelta);
        }
        return world.getThunderLevel(tickDelta);
    }
}

