/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.qendolin.betterclouds.compat.ReflectAccess;
import com.qendolin.betterclouds.mixin.MixinPlugin;
import com.qendolin.betterclouds.platform.ModLoader;
import com.qendolin.betterclouds.platform.ModVersion;
import com.qendolin.betterclouds.test.GameTestEnabled;
import java.util.ArrayList;
import java.util.List;

public class RuntimeMixinPlugin
extends MixinPlugin {
    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.endsWith("DimensionEffectsOverworldMixin")) {
            return ModLoaded.SODIUM_EXTRA;
        }
        return super.shouldApplyMixin(targetClassName, mixinClassName);
    }

    @Override
    public List<String> getMixins() {
        if (!ModLoader.isClientEnvironment()) {
            return null;
        }
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("BufferRendererAccessor");
        classes.add("RenderPhaseAccessor");
        classes.add("VertexBufferAccessor");
        classes.add("BackgroundRendererMixinMixin");
        classes.add("DimensionEffectsMixin");
        classes.add("DimensionEffectsOverworldMixin");
        boolean isYacl3_8_0 = ModLoader.getModVersion("yet_another_config_lib_v3").asSemVer().map(v -> v.compareTo(new ModVersion.SemVer(3, 8, 0)) >= 0).orElse(false);
        if (isYacl3_8_0) {
            throw ReflectAccess.IncompatibleModDependencyException.of("YACL", "For versions <1.21 please use YACL 3.7 or lower");
        }
        classes.add("yacl.OldOptionListGroupSeparatorEntryMixin");
        classes.add("yacl.OldOptionListOptionEntryMixin");
        if (BetterCloudsStatic.IS_DEV) {
            classes.add("GlDebugMixin");
        }
        if (GameTestEnabled.ENABLED) {
            classes.add("GameTestClientMixin");
            classes.add("GameTestInputUtilMixin");
            classes.add("GameTestLevelSummaryMixin");
            classes.add("GameTestWindowMixin");
        }
        if (classes.isEmpty()) {
            return null;
        }
        return classes;
    }
}

